/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.hidensity.nativememory;

import com.hazelcast.internal.hidensity.HiDensityRecord;
import com.hazelcast.internal.hidensity.HiDensityRecordAccessor;
import com.hazelcast.internal.hidensity.HiDensityStorageInfo;
import com.hazelcast.internal.hidensity.impl.DefaultHiDensityRecordProcessor;
import com.hazelcast.internal.memory.HazelcastMemoryManager;
import com.hazelcast.internal.memory.MemoryBlock;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;

public class CacheHiDensityRecordProcessor<R extends HiDensityRecord>
extends DefaultHiDensityRecordProcessor<R> {
    public CacheHiDensityRecordProcessor(EnterpriseSerializationService serializationService, HiDensityRecordAccessor<R> recordAccessor, HazelcastMemoryManager memoryManager, HiDensityStorageInfo storageInfo) {
        super(serializationService, recordAccessor, memoryManager, storageInfo);
    }

    @Override
    public void disposeDeferredBlocks() {
        MemoryBlock block;
        while ((block = (MemoryBlock)this.deferredBlocksQueue.poll()) != null) {
            if (0L == block.address()) continue;
            if (block instanceof NativeMemoryData) {
                NativeMemoryData data = (NativeMemoryData)block;
                this.recordAccessor.disposeData(data);
                continue;
            }
            if (block instanceof HiDensityRecord) {
                this.recordAccessor.dispose((HiDensityRecord)block);
                continue;
            }
            this.memoryManager.free(block.address(), block.size());
        }
    }
}

