/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.io.github.jbellis.jvector.vector;

import com.hazelcast.shaded.io.github.jbellis.jvector.util.RamUsageEstimator;
import com.hazelcast.shaded.io.github.jbellis.jvector.vector.types.ByteSequence;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.Buffer;
import java.nio.ByteOrder;

public class MemorySegmentByteSequence
implements ByteSequence<MemorySegment> {
    private final MemorySegment segment;
    private final int length;
    private static final ValueLayout.OfShort LITTLE_ENDIAN_SHORT_LAYOUT_UNALIGNED = ValueLayout.JAVA_SHORT_UNALIGNED.withOrder(ByteOrder.LITTLE_ENDIAN);

    MemorySegmentByteSequence(int length) {
        this.length = length;
        this.segment = MemorySegment.ofArray(new byte[length]);
    }

    MemorySegmentByteSequence(Buffer data) {
        this(data.remaining());
        this.segment.copyFrom(MemorySegment.ofBuffer(data));
    }

    MemorySegmentByteSequence(byte[] data) {
        this.segment = MemorySegment.ofArray(data);
        this.length = data.length;
    }

    private MemorySegmentByteSequence(MemorySegment segment) {
        this.segment = segment;
        this.length = Math.toIntExact(segment.byteSize());
    }

    @Override
    public long ramBytesUsed() {
        int OH_BYTES = RamUsageEstimator.NUM_BYTES_OBJECT_HEADER;
        int REF_BYTES = RamUsageEstimator.NUM_BYTES_OBJECT_REF;
        return (long)(OH_BYTES + REF_BYTES + 4) + MemoryLayout.sequenceLayout(this.length, ValueLayout.JAVA_BYTE).byteSize();
    }

    @Override
    public void copyFrom(ByteSequence<?> src, int srcOffset, int destOffset, int length) {
        MemorySegmentByteSequence csrc = (MemorySegmentByteSequence)src;
        this.segment.asSlice((long)destOffset, length).copyFrom(csrc.segment.asSlice(srcOffset));
    }

    @Override
    public MemorySegment get() {
        return this.segment;
    }

    @Override
    public int offset() {
        return 0;
    }

    @Override
    public byte get(int n) {
        return this.segment.get(ValueLayout.JAVA_BYTE, (long)n);
    }

    @Override
    public void set(int n, byte value) {
        this.segment.set(ValueLayout.JAVA_BYTE, (long)n, value);
    }

    @Override
    public void setLittleEndianShort(int shortIndex, short value) {
        this.segment.set(LITTLE_ENDIAN_SHORT_LAYOUT_UNALIGNED, (long)(shortIndex * 2), value);
    }

    @Override
    public void zero() {
        this.segment.fill((byte)0);
    }

    @Override
    public int length() {
        return (int)this.segment.byteSize();
    }

    @Override
    public ByteSequence<MemorySegment> copy() {
        MemorySegmentByteSequence copy = new MemorySegmentByteSequence(this.length());
        copy.copyFrom(this, 0, 0, this.length());
        return copy;
    }

    public MemorySegmentByteSequence slice(int offset, int length) {
        return new MemorySegmentByteSequence(this.segment.asSlice((long)offset, length));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < Math.min(this.length, 25); ++i) {
            sb.append(this.get(i));
            if (i >= this.length - 1) continue;
            sb.append(", ");
        }
        if (this.length > 25) {
            sb.append("...");
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        return this.equalTo(o);
    }

    public int hashCode() {
        return this.getHashCode();
    }
}

