/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.io.github.jbellis.jvector.disk;

import com.hazelcast.shaded.io.github.jbellis.jvector.disk.RandomAccessReader;
import com.hazelcast.shaded.io.github.jbellis.jvector.disk.ReaderSupplier;
import java.io.IOException;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class MemorySegmentReader
implements RandomAccessReader {
    private static final ValueLayout.OfInt intLayout = ValueLayout.JAVA_INT_UNALIGNED.withOrder(ByteOrder.BIG_ENDIAN);
    private static final ValueLayout.OfFloat floatLayout = ValueLayout.JAVA_FLOAT_UNALIGNED.withOrder(ByteOrder.BIG_ENDIAN);
    private static final ValueLayout.OfLong longLayout = ValueLayout.JAVA_LONG_UNALIGNED.withOrder(ByteOrder.BIG_ENDIAN);
    final Arena arena;
    final MemorySegment memory;
    private long position = 0L;

    public MemorySegmentReader(Path path) throws IOException {
        this.arena = Arena.ofShared();
        try (FileChannel ch = FileChannel.open(path, StandardOpenOption.READ);){
            this.memory = ch.map(FileChannel.MapMode.READ_ONLY, 0L, ch.size(), this.arena);
        }
        catch (Exception e) {
            this.arena.close();
            throw e;
        }
    }

    MemorySegmentReader(Arena arena, MemorySegment memory) {
        this.arena = arena;
        this.memory = memory;
    }

    @Override
    public void seek(long offset) {
        this.position = offset;
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public void readFully(float[] buffer) {
        MemorySegment.copy(this.memory, floatLayout, this.position, buffer, 0, buffer.length);
        this.position += (long)buffer.length * 4L;
    }

    @Override
    public void readFully(byte[] b) {
        MemorySegment.copy(this.memory, ValueLayout.JAVA_BYTE, this.position, b, 0, b.length);
        this.position += (long)b.length;
    }

    @Override
    public void readFully(ByteBuffer buffer) {
        int remaining = buffer.remaining();
        ByteBuffer slice = this.memory.asSlice(this.position, remaining).asByteBuffer();
        buffer.put(slice);
        this.position += (long)remaining;
    }

    @Override
    public void readFully(long[] vector) {
        MemorySegment.copy(this.memory, longLayout, this.position, vector, 0, vector.length);
        this.position += (long)vector.length * 8L;
    }

    @Override
    public int readInt() {
        int k = this.memory.get(intLayout, this.position);
        this.position += 4L;
        return k;
    }

    @Override
    public float readFloat() {
        float f = this.memory.get(floatLayout, this.position);
        this.position += 4L;
        return f;
    }

    @Override
    public void read(int[] ints, int offset, int count) {
        MemorySegment.copy(this.memory, intLayout, this.position, ints, offset, count);
        this.position += (long)count * 4L;
    }

    @Override
    public void read(float[] floats, int offset, int count) {
        MemorySegment.copy(this.memory, floatLayout, this.position, floats, offset, count);
        this.position += (long)count * 4L;
    }

    public void loadMemory() {
        this.memory.load();
    }

    @Override
    public void close() {
        this.arena.close();
    }

    public MemorySegmentReader duplicate() {
        return new MemorySegmentReader(this.arena, this.memory);
    }

    public static class Supplier
    implements ReaderSupplier {
        private final InternalMemorySegmentReader reader;

        public Supplier(Path path) throws IOException {
            this.reader = new InternalMemorySegmentReader(path);
        }

        @Override
        public RandomAccessReader get() {
            return this.reader.duplicate();
        }

        @Override
        public void close() {
            this.reader.close();
        }

        private static class InternalMemorySegmentReader
        extends MemorySegmentReader {
            private final boolean shouldClose;

            private InternalMemorySegmentReader(Path path) throws IOException {
                super(path);
                this.shouldClose = true;
            }

            private InternalMemorySegmentReader(Arena arena, MemorySegment memory) {
                super(arena, memory);
                this.shouldClose = false;
            }

            @Override
            public void close() {
                if (this.shouldClose) {
                    super.close();
                }
            }

            @Override
            public InternalMemorySegmentReader duplicate() {
                return new InternalMemorySegmentReader(this.arena, this.memory);
            }
        }
    }
}

