/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.type.converter;

import com.hazelcast.internal.serialization.SerializableByConvention;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.QueryDataTypeUtils;
import com.hazelcast.sql.impl.type.converter.Converter;
import java.math.BigDecimal;

@SerializableByConvention
public final class ByteConverter
extends Converter {
    public static final ByteConverter INSTANCE = new ByteConverter();

    private ByteConverter() {
        super(1, QueryDataTypeFamily.TINYINT);
    }

    @Override
    public Class<?> getValueClass() {
        return Byte.class;
    }

    @Override
    public byte asTinyint(Object val) {
        return this.cast(val);
    }

    @Override
    public short asSmallint(Object val) {
        return this.cast(val);
    }

    @Override
    public int asInt(Object val) {
        return this.cast(val);
    }

    @Override
    public long asBigint(Object val) {
        return this.cast(val);
    }

    @Override
    public BigDecimal asDecimal(Object val) {
        return new BigDecimal(this.cast(val), QueryDataTypeUtils.DECIMAL_MATH_CONTEXT);
    }

    @Override
    public float asReal(Object val) {
        return this.cast(val);
    }

    @Override
    public double asDouble(Object val) {
        return this.cast(val);
    }

    @Override
    public String asVarchar(Object val) {
        return Byte.toString(this.cast(val));
    }

    @Override
    public Object convertToSelf(Converter valConverter, Object val) {
        return valConverter.asTinyint(val);
    }

    private byte cast(Object val) {
        return (Byte)val;
    }
}

