/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.jsfr.json;

import com.hazelcast.shaded.com.fasterxml.jackson.core.JsonFactory;
import com.hazelcast.shaded.com.fasterxml.jackson.core.JsonParser;
import com.hazelcast.shaded.com.fasterxml.jackson.core.JsonToken;
import com.hazelcast.shaded.com.fasterxml.jackson.core.json.async.NonBlockingJsonParser;
import com.hazelcast.shaded.org.jsfr.json.AbstractPrimitiveHolder;
import com.hazelcast.shaded.org.jsfr.json.JsonParserAdapter;
import com.hazelcast.shaded.org.jsfr.json.NonBlockingParser;
import com.hazelcast.shaded.org.jsfr.json.ResumableParser;
import com.hazelcast.shaded.org.jsfr.json.StaticPrimitiveHolder;
import com.hazelcast.shaded.org.jsfr.json.SurfingContext;
import com.hazelcast.shaded.org.jsfr.json.provider.JsonProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class JacksonJrParser
implements JsonParserAdapter {
    public static final JacksonJrParser INSTANCE = new JacksonJrParser();
    private final JsonFactory factory = new JsonFactory();

    @Override
    public void parse(Reader reader, SurfingContext context) {
        this.createResumableParser(reader, context).parse();
    }

    @Override
    public void parse(String json, SurfingContext context) {
        this.createResumableParser(json, context).parse();
    }

    @Override
    public void parse(InputStream inputStream, SurfingContext context) {
        this.createResumableParser(inputStream, context).parse();
    }

    @Override
    public ResumableParser createResumableParser(Reader reader, SurfingContext context) {
        try {
            JsonParser jp = this.factory.createParser(reader);
            return this.createResumableParser(jp, context);
        }
        catch (Exception e) {
            context.getConfig().getErrorHandlingStrategy().handleParsingException(e);
            return null;
        }
    }

    @Override
    public ResumableParser createResumableParser(String json, SurfingContext context) {
        try {
            JsonParser jp = this.factory.createParser(json);
            return this.createResumableParser(jp, context);
        }
        catch (Exception e) {
            context.getConfig().getErrorHandlingStrategy().handleParsingException(e);
            return null;
        }
    }

    @Override
    public ResumableParser createResumableParser(InputStream json, SurfingContext context) {
        try {
            JsonParser jp = this.factory.createParser(json);
            return this.createResumableParser(jp, context);
        }
        catch (Exception e) {
            context.getConfig().getErrorHandlingStrategy().handleParsingException(e);
            return null;
        }
    }

    @Override
    public NonBlockingParser createNonBlockingParser(SurfingContext context) {
        try {
            NonBlockingJsonParser jp = (NonBlockingJsonParser)this.factory.createNonBlockingByteArrayParser();
            return new JacksonNonblockingParser(jp, context);
        }
        catch (IOException e) {
            context.getConfig().getErrorHandlingStrategy().handleParsingException(e);
            return null;
        }
    }

    private JacksonResumableParser createResumableParser(JsonParser jp, SurfingContext context) {
        return new JacksonResumableParser(jp, context);
    }

    private static class JacksonResumableParser
    implements ResumableParser {
        protected SurfingContext context;
        private final JsonParser jsonParser;
        private final AbstractPrimitiveHolder stringHolder;
        private final AbstractPrimitiveHolder longHolder;
        private final AbstractPrimitiveHolder doubleHolder;
        private final StaticPrimitiveHolder staticHolder;

        JacksonResumableParser(final JsonParser jsonParser, SurfingContext context) {
            this.jsonParser = jsonParser;
            this.context = context;
            final JsonProvider jsonProvider = context.getConfig().getJsonProvider();
            this.stringHolder = new AbstractPrimitiveHolder(context.getConfig()){

                @Override
                public Object doGetValue() throws IOException {
                    return jsonProvider.primitive(jsonParser.getText());
                }

                @Override
                public void doSkipValue() throws IOException {
                }
            };
            this.longHolder = new AbstractPrimitiveHolder(context.getConfig()){

                @Override
                public Object doGetValue() throws IOException {
                    if (jsonParser.getNumberType() == JsonParser.NumberType.BIG_INTEGER) {
                        return jsonProvider.primitive(jsonParser.getBigIntegerValue());
                    }
                    return jsonProvider.primitive(jsonParser.getLongValue());
                }

                @Override
                public void doSkipValue() {
                }
            };
            this.doubleHolder = new AbstractPrimitiveHolder(context.getConfig()){

                @Override
                public Object doGetValue() throws IOException {
                    return jsonProvider.primitive(jsonParser.getDoubleValue());
                }

                @Override
                public void doSkipValue() {
                }
            };
            this.staticHolder = new StaticPrimitiveHolder();
        }

        @Override
        public boolean resume() {
            try {
                if (!this.context.isPaused()) {
                    return false;
                }
                this.context.resume();
                this.doParse();
                return true;
            }
            catch (Exception e) {
                this.context.getConfig().getErrorHandlingStrategy().handleParsingException(e);
                return false;
            }
        }

        @Override
        public void parse() {
            this.context.startJSON();
            try {
                this.doParse();
            }
            catch (Exception e) {
                this.context.getConfig().getErrorHandlingStrategy().handleParsingException(e);
            }
        }

        void doParse() throws IOException {
            JsonProvider jsonProvider = this.context.getConfig().getJsonProvider();
            block14: while (!this.context.shouldBreak()) {
                JsonToken token = this.jsonParser.nextToken();
                if (token == null) {
                    this.context.endJSON();
                    break;
                }
                switch (token) {
                    case NOT_AVAILABLE: {
                        this.context.pause();
                        continue block14;
                    }
                    case START_OBJECT: {
                        this.context.startObject();
                        continue block14;
                    }
                    case END_OBJECT: {
                        this.context.endObject();
                        continue block14;
                    }
                    case START_ARRAY: {
                        this.context.startArray();
                        continue block14;
                    }
                    case END_ARRAY: {
                        this.context.endArray();
                        continue block14;
                    }
                    case FIELD_NAME: {
                        this.context.startObjectEntry(this.jsonParser.getCurrentName());
                        continue block14;
                    }
                    case VALUE_STRING: {
                        this.stringHolder.init();
                        this.context.primitive(this.stringHolder);
                        this.stringHolder.skipValue();
                        continue block14;
                    }
                    case VALUE_NUMBER_INT: {
                        this.longHolder.init();
                        this.context.primitive(this.longHolder);
                        this.longHolder.skipValue();
                        continue block14;
                    }
                    case VALUE_NUMBER_FLOAT: {
                        this.doubleHolder.init();
                        this.context.primitive(this.doubleHolder);
                        this.doubleHolder.skipValue();
                        continue block14;
                    }
                    case VALUE_TRUE: {
                        this.context.primitive(this.staticHolder.withValue(jsonProvider.primitive(true)));
                        continue block14;
                    }
                    case VALUE_FALSE: {
                        this.context.primitive(this.staticHolder.withValue(jsonProvider.primitive(false)));
                        continue block14;
                    }
                    case VALUE_NULL: {
                        this.context.primitive(this.staticHolder.withValue(jsonProvider.primitiveNull()));
                        continue block14;
                    }
                }
                throw new IllegalStateException("Unexpected token");
            }
            if (this.context.getConfig().isCloseParserOnStop() && this.context.isStopped()) {
                this.jsonParser.close();
            }
        }
    }

    private static class JacksonNonblockingParser
    extends JacksonResumableParser
    implements NonBlockingParser {
        private NonBlockingJsonParser nonBlockingJsonParser;

        JacksonNonblockingParser(NonBlockingJsonParser jsonParser, SurfingContext context) {
            super((JsonParser)jsonParser, context);
            this.nonBlockingJsonParser = jsonParser;
        }

        @Override
        public boolean feed(byte[] bytes, int start, int end) {
            try {
                if (this.nonBlockingJsonParser.needMoreInput() && !this.context.isStopped()) {
                    this.nonBlockingJsonParser.feedInput(bytes, start, end);
                    if (this.context.isPaused()) {
                        this.context.resume();
                        this.doParse();
                    } else {
                        this.parse();
                    }
                    return true;
                }
            }
            catch (IOException e) {
                this.context.getConfig().getErrorHandlingStrategy().handleParsingException(e);
            }
            return false;
        }

        @Override
        public void endOfInput() {
            this.nonBlockingJsonParser.endOfInput();
            this.resume();
        }
    }
}

