/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.distribution;

import com.hazelcast.shaded.org.apache.commons.math3.Field;
import com.hazelcast.shaded.org.apache.commons.math3.FieldElement;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathArithmeticException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooLargeException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.util.Localizable;
import com.hazelcast.shaded.org.apache.commons.math3.exception.util.LocalizedFormats;
import com.hazelcast.shaded.org.apache.commons.math3.fraction.BigFraction;
import com.hazelcast.shaded.org.apache.commons.math3.fraction.BigFractionField;
import com.hazelcast.shaded.org.apache.commons.math3.fraction.FractionConversionException;
import com.hazelcast.shaded.org.apache.commons.math3.linear.Array2DRowFieldMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.Array2DRowRealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.FieldMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KolmogorovSmirnovDistribution
implements Serializable {
    private static final long serialVersionUID = -4670676796862967187L;
    private int n;

    public KolmogorovSmirnovDistribution(int n) throws NotStrictlyPositiveException {
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NOT_POSITIVE_NUMBER_OF_SAMPLES, n);
        }
        this.n = n;
    }

    public double cdf(double d) throws MathArithmeticException {
        return this.cdf(d, false);
    }

    public double cdfExact(double d) throws MathArithmeticException {
        return this.cdf(d, true);
    }

    public double cdf(double d, boolean exact) throws MathArithmeticException {
        double ninv = 1.0 / (double)this.n;
        double ninvhalf = 0.5 * ninv;
        if (d <= ninvhalf) {
            return 0.0;
        }
        if (ninvhalf < d && d <= ninv) {
            double res = 1.0;
            double f = 2.0 * d - ninv;
            for (int i = 1; i <= this.n; ++i) {
                res *= (double)i * f;
            }
            return res;
        }
        if (1.0 - ninv <= d && d < 1.0) {
            return 1.0 - 2.0 * FastMath.pow(1.0 - d, this.n);
        }
        if (1.0 <= d) {
            return 1.0;
        }
        return exact ? this.exactK(d) : this.roundedK(d);
    }

    private double exactK(double d) throws MathArithmeticException {
        int k = (int)FastMath.ceil((double)this.n * d);
        FieldMatrix<BigFraction> H = this.createH(d);
        FieldMatrix<BigFraction> Hpower = H.power(this.n);
        BigFraction pFrac = Hpower.getEntry(k - 1, k - 1);
        for (int i = 1; i <= this.n; ++i) {
            pFrac = pFrac.multiply(i).divide(this.n);
        }
        return pFrac.bigDecimalValue(20, 4).doubleValue();
    }

    private double roundedK(double d) throws MathArithmeticException {
        int k = (int)FastMath.ceil((double)this.n * d);
        FieldMatrix<BigFraction> HBigFraction = this.createH(d);
        int m4 = HBigFraction.getRowDimension();
        Array2DRowRealMatrix H = new Array2DRowRealMatrix(m4, m4);
        for (int i = 0; i < m4; ++i) {
            for (int j = 0; j < m4; ++j) {
                H.setEntry(i, j, HBigFraction.getEntry(i, j).doubleValue());
            }
        }
        RealMatrix Hpower = H.power(this.n);
        double pFrac = Hpower.getEntry(k - 1, k - 1);
        for (int i = 1; i <= this.n; ++i) {
            pFrac *= (double)i / (double)this.n;
        }
        return pFrac;
    }

    private FieldMatrix<BigFraction> createH(double d) throws NumberIsTooLargeException, FractionConversionException {
        int i;
        int k = (int)FastMath.ceil((double)this.n * d);
        int m4 = 2 * k - 1;
        double hDouble = (double)k - (double)this.n * d;
        if (hDouble >= 1.0) {
            throw new NumberIsTooLargeException(hDouble, (Number)1.0, false);
        }
        BigFraction h2 = null;
        try {
            h2 = new BigFraction(hDouble, 1.0E-20, 10000);
        }
        catch (FractionConversionException e1) {
            try {
                h2 = new BigFraction(hDouble, 1.0E-10, 10000);
            }
            catch (FractionConversionException e2) {
                h2 = new BigFraction(hDouble, 1.0E-5, 10000);
            }
        }
        FieldElement[][] Hdata = new BigFraction[m4][m4];
        for (int i2 = 0; i2 < m4; ++i2) {
            for (int j = 0; j < m4; ++j) {
                Hdata[i2][j] = i2 - j + 1 < 0 ? BigFraction.ZERO : BigFraction.ONE;
            }
        }
        BigFraction[] hPowers = new BigFraction[m4];
        hPowers[0] = h2;
        for (i = 1; i < m4; ++i) {
            hPowers[i] = h2.multiply(hPowers[i - 1]);
        }
        for (i = 0; i < m4; ++i) {
            Hdata[i][0] = Hdata[i][0].subtract(hPowers[i]);
            Hdata[m4 - 1][i] = ((BigFraction)Hdata[m4 - 1][i]).subtract(hPowers[m4 - i - 1]);
        }
        if (h2.compareTo(BigFraction.ONE_HALF) == 1) {
            Hdata[m4 - 1][0] = ((BigFraction)Hdata[m4 - 1][0]).add(h2.multiply(2).subtract(1).pow(m4));
        }
        for (i = 0; i < m4; ++i) {
            for (int j = 0; j < i + 1; ++j) {
                if (i - j + 1 <= 0) continue;
                for (int g2 = 2; g2 <= i - j + 1; ++g2) {
                    Hdata[i][j] = ((BigFraction)Hdata[i][j]).divide(g2);
                }
            }
        }
        return new Array2DRowFieldMatrix((Field)BigFractionField.getInstance(), Hdata);
    }
}

