/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql.validate;

import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.com.google.common.collect.ImmutableMap;
import com.hazelcast.shaded.com.google.common.collect.ImmutableSortedMultiset;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Linq4j;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Ord;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSelect;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.AggChecker;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.AggregatingScope;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.DelegatingScope;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SelectScope;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorUtil;
import com.hazelcast.shaded.org.apache.calcite.util.ImmutableBitSet;
import com.hazelcast.shaded.org.apache.calcite.util.Litmus;
import com.hazelcast.shaded.org.apache.calcite.util.Util;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AggregatingSelectScope
extends DelegatingScope
implements AggregatingScope {
    private final SqlSelect select;
    private final boolean distinct;

    AggregatingSelectScope(SqlValidatorScope selectScope, SqlSelect select, boolean distinct) {
        super(selectScope);
        this.select = select;
        this.distinct = distinct;
    }

    @Override
    protected void analyze(SqlValidatorUtil.GroupAnalyzer analyzer) {
        super.analyze(analyzer);
        ImmutableList.Builder<ImmutableList<ImmutableBitSet>> builder = ImmutableList.builder();
        boolean groupByDistinct = false;
        if (this.select.getGroup() != null) {
            SqlNodeList groupList = this.select.getGroup();
            if (groupList.size() == 1 && groupList.get(0).getKind() == SqlKind.GROUP_BY_DISTINCT) {
                groupList = new SqlNodeList(((SqlCall)groupList.get(0)).getOperandList(), groupList.getParserPosition());
                groupByDistinct = true;
            }
            for (SqlNode groupExpr : groupList) {
                SqlValidatorUtil.analyzeGroupItem(this, analyzer, builder, groupExpr);
            }
        }
        for (List groupSet : Linq4j.product(builder.build())) {
            analyzer.flatGroupSets.add(ImmutableBitSet.union(groupSet));
        }
        if (analyzer.flatGroupSets.isEmpty()) {
            analyzer.flatGroupSets.add(ImmutableBitSet.of());
        }
        if (groupByDistinct) {
            AggregatingSelectScope.assign(analyzer.flatGroupSets, Util.distinctList(analyzer.flatGroupSets));
        }
    }

    private static <E> void assign(Collection<E> target, Collection<E> source) {
        if (source == target) {
            return;
        }
        target.clear();
        target.addAll(source);
    }

    private void gatherGroupExprs(ImmutableList.Builder<SqlNode> extraExprs, ImmutableList.Builder<SqlNode> measureExprs, ImmutableList.Builder<SqlNode> groupExprs) {
        if (this.distinct) {
            assert (this.select.isDistinct());
            SelectScope selectScope = (SelectScope)this.parent;
            List<SqlNode> expandedSelectList = Objects.requireNonNull(selectScope.getExpandedSelectList(), () -> "expandedSelectList for " + selectScope);
            for (SqlNode selectItem : expandedSelectList) {
                groupExprs.add((Object)SqlUtil.stripAs(selectItem));
            }
        } else {
            SqlValidatorUtil.GroupAnalyzer groupAnalyzer = this.groupAnalyzer;
            if (groupAnalyzer != null) {
                extraExprs.addAll(groupAnalyzer.extraExprs);
                measureExprs.addAll(groupAnalyzer.measureExprs);
                groupExprs.addAll(groupAnalyzer.groupExprs);
            } else {
                Resolved resolved = (Resolved)this.resolved.get();
                extraExprs.addAll(resolved.extraExprList);
                measureExprs.addAll(resolved.measureExprList);
                groupExprs.addAll(resolved.groupExprList);
            }
        }
    }

    @Override
    public SqlSelect getNode() {
        return this.select;
    }

    @Override
    public RelDataType nullifyType(SqlNode node, RelDataType type) {
        Resolved r = (Resolved)this.resolved.get();
        for (Ord<SqlNode> groupExpr : Ord.zip(r.groupExprList)) {
            if (!((SqlNode)groupExpr.e).equalsDeep(node, Litmus.IGNORE) || !r.isNullable(groupExpr.i)) continue;
            return this.validator.getTypeFactory().createTypeWithNullability(type, true);
        }
        return type;
    }

    @Override
    public SqlValidatorScope getOperandScope(SqlCall call) {
        if (call.getOperator().isAggregator()) {
            return this.parent;
        }
        boolean matches = this.checkAggregateExpr(call, false);
        if (matches) {
            return this.parent;
        }
        return super.getOperandScope(call);
    }

    @Override
    public boolean checkAggregateExpr(SqlNode expr, boolean deep) {
        if (deep) {
            expr = this.validator.expand(expr, this);
        }
        ImmutableList.Builder<SqlNode> extraExprs = ImmutableList.builder();
        ImmutableList.Builder<SqlNode> measureExprs = ImmutableList.builder();
        ImmutableList.Builder<SqlNode> groupExprs = ImmutableList.builder();
        this.gatherGroupExprs(extraExprs, measureExprs, groupExprs);
        AggChecker aggChecker = new AggChecker(this.validator, this, (List<SqlNode>)((Object)extraExprs.build()), (List<SqlNode>)((Object)measureExprs.build()), (List<SqlNode>)((Object)groupExprs.build()), this.distinct);
        if (deep) {
            expr.accept(aggChecker);
        }
        return aggChecker.isGroupExpr(expr);
    }

    @Override
    public void validateExpr(SqlNode expr) {
        this.checkAggregateExpr(expr, true);
    }

    public static class Resolved {
        public final ImmutableList<SqlNode> extraExprList;
        public final ImmutableList<SqlNode> measureExprList;
        public final ImmutableList<SqlNode> groupExprList;
        public final ImmutableBitSet groupSet;
        public final ImmutableSortedMultiset<ImmutableBitSet> groupSets;
        public final Map<Integer, Integer> groupExprProjection;

        Resolved(List<SqlNode> extraExprList, List<SqlNode> measureExprList, List<SqlNode> groupExprList, Iterable<ImmutableBitSet> groupSets, Map<Integer, Integer> groupExprProjection) {
            this.extraExprList = ImmutableList.copyOf(extraExprList);
            this.measureExprList = ImmutableList.copyOf(measureExprList);
            this.groupExprList = ImmutableList.copyOf(groupExprList);
            this.groupSet = ImmutableBitSet.range(groupExprList.size());
            this.groupSets = ImmutableSortedMultiset.copyOf(groupSets);
            this.groupExprProjection = ImmutableMap.copyOf(groupExprProjection);
        }

        public boolean isNullable(int i) {
            return i < this.groupExprList.size() && !ImmutableBitSet.allContain(this.groupSets, i);
        }

        public boolean isGroupingExpr(SqlNode operand) {
            return this.lookupGroupingExpr(operand) >= 0;
        }

        public int lookupGroupingExpr(SqlNode operand) {
            return SqlUtil.indexOfDeep(this.groupExprList, operand, Litmus.IGNORE);
        }
    }
}

