/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.rel.rules;

import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.com.google.common.collect.ImmutableSet;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.shaded.org.apache.calcite.plan.RelRule;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Join;
import com.hazelcast.shaded.org.apache.calcite.rel.core.JoinInfo;
import com.hazelcast.shaded.org.apache.calcite.rel.core.JoinRelType;
import com.hazelcast.shaded.org.apache.calcite.rel.logical.LogicalJoin;
import com.hazelcast.shaded.org.apache.calcite.rel.rules.ImmutableJoinAddRedundantSemiJoinRule;
import com.hazelcast.shaded.org.apache.calcite.rel.rules.TransformationRule;
import com.hazelcast.shaded.org.apache.calcite.tools.RelBuilderFactory;
import org.immutables.value.Value;

@Value.Enclosing
public class JoinAddRedundantSemiJoinRule
extends RelRule<Config>
implements TransformationRule {
    protected JoinAddRedundantSemiJoinRule(Config config) {
        super(config);
    }

    @Deprecated
    public JoinAddRedundantSemiJoinRule(Class<? extends Join> clazz, RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class).withOperandFor(clazz));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Join origJoinRel = (Join)call.rel(0);
        if (origJoinRel.isSemiJoinDone()) {
            return;
        }
        if (origJoinRel.getJoinType() != JoinRelType.INNER) {
            return;
        }
        JoinInfo joinInfo = origJoinRel.analyzeCondition();
        if (joinInfo.leftKeys.size() == 0) {
            return;
        }
        LogicalJoin semiJoin = LogicalJoin.create(origJoinRel.getLeft(), origJoinRel.getRight(), ImmutableList.of(), origJoinRel.getCondition(), ImmutableSet.of(), JoinRelType.SEMI);
        Join newJoinRel = origJoinRel.copy(origJoinRel.getTraitSet(), origJoinRel.getCondition(), semiJoin, origJoinRel.getRight(), JoinRelType.INNER, true);
        call.transformTo(newJoinRel);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableJoinAddRedundantSemiJoinRule.Config.of().withOperandFor(LogicalJoin.class);

        @Override
        default public JoinAddRedundantSemiJoinRule toRule() {
            return new JoinAddRedundantSemiJoinRule(this);
        }

        default public Config withOperandFor(Class<? extends Join> joinClass) {
            return this.withOperandSupplier(b -> b.operand(joinClass).anyInputs()).as(Config.class);
        }
    }
}

