/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.rel;

import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.com.google.common.collect.ImmutableSet;
import com.hazelcast.shaded.org.apache.calcite.plan.Convention;
import com.hazelcast.shaded.org.apache.calcite.plan.ConventionTraitDef;
import com.hazelcast.shaded.org.apache.calcite.plan.RelDigest;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCost;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptPlanner;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptUtil;
import com.hazelcast.shaded.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.RelShuttle;
import com.hazelcast.shaded.org.apache.calcite.rel.RelVisitor;
import com.hazelcast.shaded.org.apache.calcite.rel.RelWriter;
import com.hazelcast.shaded.org.apache.calcite.rel.core.CorrelationId;
import com.hazelcast.shaded.org.apache.calcite.rel.hint.Hintable;
import com.hazelcast.shaded.org.apache.calcite.rel.hint.RelHint;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.Metadata;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.MetadataFactory;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rex.RexShuttle;
import com.hazelcast.shaded.org.apache.calcite.runtime.PairList;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlExplainLevel;
import com.hazelcast.shaded.org.apache.calcite.util.Litmus;
import com.hazelcast.shaded.org.apache.calcite.util.Pair;
import com.hazelcast.shaded.org.apache.calcite.util.Util;
import com.hazelcast.shaded.org.checkerframework.checker.initialization.qual.UnknownInitialization;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import com.hazelcast.shaded.org.checkerframework.dataflow.qual.Pure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apiguardian.api.API;

public abstract class AbstractRelNode
implements RelNode {
    private static final AtomicInteger NEXT_ID = new AtomicInteger(0);
    protected @MonotonicNonNull RelDataType rowType;
    @API(since="1.24", status=API.Status.INTERNAL)
    protected RelDigest digest;
    private final RelOptCluster cluster;
    protected final int id;
    protected RelTraitSet traitSet;

    protected AbstractRelNode(RelOptCluster cluster, RelTraitSet traitSet) {
        assert (cluster != null);
        this.cluster = cluster;
        this.traitSet = traitSet;
        this.id = NEXT_ID.getAndIncrement();
        this.digest = new InnerRelDigest();
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        if (this.getInputs().equals(inputs) && traitSet == this.getTraitSet()) {
            return this;
        }
        throw new AssertionError((Object)("Relational expression should override copy. Class=[" + this.getClass() + "]; traits=[" + this.getTraitSet() + "]; desired traits=[" + traitSet + "]"));
    }

    protected static <T> T sole(List<T> collection) {
        assert (collection.size() == 1);
        return collection.get(0);
    }

    @Override
    public final RelOptCluster getCluster() {
        return this.cluster;
    }

    @Override
    @Pure
    public final @Nullable Convention getConvention(@UnknownInitialization AbstractRelNode this) {
        return this.traitSet == null ? null : this.traitSet.getTrait(ConventionTraitDef.INSTANCE);
    }

    @Override
    public RelTraitSet getTraitSet() {
        return this.traitSet;
    }

    @Override
    public @Nullable String getCorrelVariable() {
        return null;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public RelNode getInput(int i) {
        List<RelNode> inputs = this.getInputs();
        return inputs.get(i);
    }

    @Override
    public void register(RelOptPlanner planner) {
        Util.discard(planner);
    }

    @Override
    public String getRelTypeName() {
        String cn = this.getClass().getName();
        int i = cn.length();
        while (--i >= 0) {
            if (cn.charAt(i) != '$' && cn.charAt(i) != '.') continue;
            return cn.substring(i + 1);
        }
        return cn;
    }

    @Override
    public boolean isValid(Litmus litmus, @Nullable RelNode.Context context) {
        return litmus.succeed();
    }

    @Override
    public final RelDataType getRowType() {
        if (this.rowType == null) {
            this.rowType = this.deriveRowType();
            assert (this.rowType != null) : this;
        }
        return this.rowType;
    }

    protected RelDataType deriveRowType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RelDataType getExpectedInputRowType(int ordinalInParent) {
        return this.getRowType();
    }

    @Override
    public List<RelNode> getInputs() {
        return Collections.emptyList();
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        return 1.0;
    }

    @Override
    public Set<CorrelationId> getVariablesSet() {
        return ImmutableSet.of();
    }

    @Override
    public void collectVariablesUsed(Set<CorrelationId> variableSet) {
    }

    @Override
    public boolean isEnforcer() {
        return false;
    }

    @Override
    public void collectVariablesSet(Set<CorrelationId> variableSet) {
    }

    @Override
    public void childrenAccept(RelVisitor visitor) {
        List<RelNode> inputs = this.getInputs();
        for (int i = 0; i < inputs.size(); ++i) {
            visitor.visit(inputs.get(i), i, this);
        }
    }

    @Override
    public RelNode accept(RelShuttle shuttle) {
        return shuttle.visit(this);
    }

    @Override
    public RelNode accept(RexShuttle shuttle) {
        return this;
    }

    @Override
    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCount = mq.getRowCount(this);
        return planner.getCostFactory().makeCost(rowCount, rowCount, 0.0);
    }

    @Override
    @Deprecated
    public final <M extends Metadata> M metadata(Class<M> metadataClass, RelMetadataQuery mq) {
        MetadataFactory factory = this.cluster.getMetadataFactory();
        M metadata = factory.query(this, mq, metadataClass);
        assert (metadata != null) : "no provider found (rel=" + this + ", m=" + metadataClass + "); a backstop provider is recommended";
        return metadata;
    }

    @Override
    public void explain(RelWriter pw) {
        this.explainTerms(pw).done(this);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return pw;
    }

    @Override
    public RelNode onRegister(RelOptPlanner planner) {
        List<RelNode> oldInputs = this.getInputs();
        ArrayList<RelNode> inputs = new ArrayList<RelNode>(oldInputs.size());
        for (RelNode input : oldInputs) {
            RelNode e = planner.ensureRegistered(input, null);
            assert (e == input || RelOptUtil.equal("rowtype of rel before registration", input.getRowType(), "rowtype of rel after registration", e.getRowType(), Litmus.THROW));
            inputs.add(e);
        }
        RelNode r = this;
        if (!Util.equalShallow(oldInputs, inputs)) {
            r = this.copy(this.getTraitSet(), inputs);
        }
        r.recomputeDigest();
        assert (r.isValid(Litmus.THROW, null));
        return r;
    }

    @Override
    public void recomputeDigest() {
        this.digest.clear();
    }

    @Override
    public void replaceInput(int ordinalInParent, RelNode p) {
        throw new UnsupportedOperationException("replaceInput called on " + this);
    }

    public String toString() {
        return "rel#" + this.id + ':' + this.getDigest();
    }

    @Override
    @Deprecated
    public final String getDescription() {
        return this.toString();
    }

    @Override
    public String getDigest() {
        return this.digest.toString();
    }

    @Override
    public final RelDigest getRelDigest() {
        return this.digest;
    }

    @Override
    public @Nullable RelOptTable getTable() {
        return null;
    }

    public final boolean equals(@Nullable Object obj) {
        return super.equals(obj);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    @API(since="1.25", status=API.Status.MAINTAINED)
    public boolean deepEquals(@Nullable Object obj) {
        boolean result;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractRelNode that = (AbstractRelNode)obj;
        boolean bl = result = this.getTraitSet().equals(that.getTraitSet()) && this.getRowType().equalsSansFieldNames(that.getRowType());
        if (!result) {
            return false;
        }
        PairList<String, @Nullable Object> items1 = this.getDigestItems();
        PairList<String, @Nullable Object> items2 = that.getDigestItems();
        if (items1.size() != items2.size()) {
            return false;
        }
        for (int i = 0; result && i < items1.size(); ++i) {
            @Nullable Object attr1 = items1.get(i);
            @Nullable Object attr2 = items2.get(i);
            result = attr1.getValue() instanceof RelNode ? ((RelNode)attr1.getValue()).deepEquals(attr2.getValue()) : attr1.equals(attr2);
        }
        return result;
    }

    @Override
    @API(since="1.25", status=API.Status.MAINTAINED)
    public int deepHashCode() {
        int result = 31 + this.getTraitSet().hashCode();
        PairList<String, @Nullable Object> items = this.getDigestItems();
        for (Object value : items.rightList()) {
            int h2 = value == null ? 0 : (value instanceof RelNode ? ((RelNode)value).deepHashCode() : value.hashCode());
            result = result * 31 + h2;
        }
        return result;
    }

    private PairList<String, @Nullable Object> getDigestItems() {
        RelDigestWriter rdw = new RelDigestWriter();
        this.explainTerms(rdw);
        if (this instanceof Hintable) {
            ImmutableList<RelHint> hints;
            rdw.itemIf("hints", hints, !(hints = ((Hintable)((Object)this)).getHints()).isEmpty());
        }
        return rdw.attrs;
    }

    private static final class RelDigestWriter
    implements RelWriter {
        private final PairList<String, @Nullable Object> attrs = PairList.of();
        @Nullable String digest = null;

        private RelDigestWriter() {
        }

        @Override
        public void explain(RelNode rel, List<Pair<String, @Nullable Object>> valueList) {
            throw new IllegalStateException("Should not be called for computing digest");
        }

        @Override
        public SqlExplainLevel getDetailLevel() {
            return SqlExplainLevel.DIGEST_ATTRIBUTES;
        }

        @Override
        public RelWriter item(String term, @Nullable Object value) {
            if (value != null && value.getClass().isArray()) {
                value = "" + value;
            }
            this.attrs.add((Map.Entry<String, Object>)Pair.of(term, value));
            return this;
        }

        @Override
        public RelWriter done(RelNode node) {
            StringBuilder sb = new StringBuilder();
            sb.append(node.getRelTypeName());
            sb.append('.');
            sb.append(node.getTraitSet());
            sb.append('(');
            this.attrs.forEachIndexed((j, left, right) -> {
                if (j > 0) {
                    sb.append(',');
                }
                sb.append((String)left);
                sb.append('=');
                if (right instanceof RelNode) {
                    RelNode input = (RelNode)right;
                    sb.append(input.getRelTypeName());
                    sb.append('#');
                    sb.append(input.getId());
                } else {
                    sb.append(right);
                }
            });
            sb.append(')');
            this.digest = sb.toString();
            return this;
        }
    }

    private class InnerRelDigest
    implements RelDigest {
        private int hash = 0;

        private InnerRelDigest() {
        }

        @Override
        public RelNode getRel() {
            return AbstractRelNode.this;
        }

        @Override
        public void clear() {
            this.hash = 0;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InnerRelDigest relDigest = (InnerRelDigest)o;
            return AbstractRelNode.this.deepEquals(relDigest.getRel());
        }

        public int hashCode() {
            if (this.hash == 0) {
                this.hash = AbstractRelNode.this.deepHashCode();
            }
            return this.hash;
        }

        public String toString() {
            RelDigestWriter rdw = new RelDigestWriter();
            AbstractRelNode.this.explain(rdw);
            return Objects.requireNonNull(rdw.digest, "digest");
        }
    }
}

