/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.literal;

import com.hazelcast.jet.sql.impl.validate.literal.IntervalLiteral;
import com.hazelcast.jet.sql.impl.validate.literal.Literal;
import com.hazelcast.jet.sql.impl.validate.literal.NumericLiteral;
import com.hazelcast.jet.sql.impl.validate.literal.TypedLiteral;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeFactory;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeUtils;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rex.RexLiteral;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIntervalLiteral;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.shaded.org.apache.calcite.util.NlsString;
import com.hazelcast.shaded.org.apache.calcite.util.TimeString;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.temporal.Temporal;
import java.util.Calendar;

public final class LiteralUtils {
    private static final long NANOSECOND_IN_MILLISECOND = 1000000L;

    private LiteralUtils() {
    }

    public static Literal literal(RexNode node) {
        if (node.getKind() != SqlKind.LITERAL) {
            return null;
        }
        RexLiteral literal = (RexLiteral)node;
        SqlTypeName typeName = literal.getTypeName();
        Comparable value = SqlTypeName.DATETIME_TYPES.contains((Object)typeName) && typeName != SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE ? LiteralUtils.createDateTimeValue(typeName, literal) : literal.getValue();
        return LiteralUtils.literal0(node.getType().getSqlTypeName(), value);
    }

    public static Literal literal(SqlNode node) {
        if (node.getKind() != SqlKind.LITERAL) {
            return null;
        }
        SqlLiteral literal = (SqlLiteral)node;
        SqlTypeName typeName = literal.getTypeName();
        Object value = SqlTypeName.CHAR_TYPES.contains((Object)typeName) ? literal.toValue() : literal.getValue();
        return LiteralUtils.literal0(typeName, value);
    }

    private static Literal literal0(SqlTypeName typeName, Object value) {
        if (typeName == SqlTypeName.SYMBOL) {
            return null;
        }
        if (HazelcastTypeUtils.isNumericType(typeName)) {
            return NumericLiteral.create(typeName, value);
        }
        if (SqlTypeName.CHAR_TYPES.contains((Object)typeName)) {
            if (value instanceof NlsString) {
                value = ((NlsString)value).getValue();
            }
            assert (value instanceof String) : value.getClass().getName();
            return new TypedLiteral(value, SqlTypeName.VARCHAR);
        }
        if (value instanceof SqlIntervalLiteral.IntervalValue) {
            return new IntervalLiteral((SqlIntervalLiteral.IntervalValue)value, typeName);
        }
        return new TypedLiteral(value, typeName);
    }

    public static SqlTypeName literalTypeName(SqlNode node) {
        Literal literal = LiteralUtils.literal(node);
        return literal != null ? literal.getTypeName() : null;
    }

    public static RelDataType literalType(SqlNode node, HazelcastTypeFactory typeFactory) {
        Literal literal = LiteralUtils.literal(node);
        return literal != null ? literal.getType(typeFactory) : null;
    }

    private static Temporal createDateTimeValue(SqlTypeName typeName, RexLiteral literal) {
        switch (typeName) {
            case TIME: {
                return LocalTime.ofNanoOfDay((long)literal.getValueAs(TimeString.class).getMillisOfDay() * 1000000L);
            }
            case TIMESTAMP: {
                Calendar calendar = (Calendar)literal.getValue();
                return LocalDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                Calendar calendar = (Calendar)literal.getValue();
                return OffsetDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
            }
            case DATE: {
                return LocalDate.ofEpochDay(literal.getValueAs(Integer.class).intValue());
            }
        }
        throw new IllegalArgumentException("Unexpected type: " + String.valueOf((Object)typeName));
    }
}

