/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.inject;

import com.hazelcast.internal.serialization.ReflectionClassNameFilter;
import com.hazelcast.jet.sql.impl.inject.PojoUpsertTarget;
import com.hazelcast.jet.sql.impl.inject.UpsertTarget;
import com.hazelcast.jet.sql.impl.inject.UpsertTargetDescriptor;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.ClassNameFilter;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

public class PojoUpsertTargetDescriptor
implements UpsertTargetDescriptor {
    private String className;
    private Map<String, String> typeNamesByPaths;

    private PojoUpsertTargetDescriptor() {
    }

    public PojoUpsertTargetDescriptor(String className, Map<String, String> typeNamesByPaths) {
        this.className = className;
        this.typeNamesByPaths = typeNamesByPaths;
    }

    @Override
    public UpsertTarget create(ExpressionEvalContext evalContext) {
        ReflectionClassNameFilter classFilter = evalContext.getNodeEngine().getSqlService().getReflectionClassNameFilter();
        return new PojoUpsertTarget(this.className, this.typeNamesByPaths, (ClassNameFilter)classFilter);
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.className);
        out.writeObject(this.typeNamesByPaths);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.className = in.readString();
        this.typeNamesByPaths = (Map)in.readObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PojoUpsertTargetDescriptor that = (PojoUpsertTargetDescriptor)o;
        return Objects.equals(this.className, that.className) && Objects.equals(this.typeNamesByPaths, that.typeNamesByPaths);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.typeNamesByPaths);
    }
}

