/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.cluster.Address;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.PartitioningStrategyUtil;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.connector.HazelcastReaders;
import com.hazelcast.jet.impl.connector.ReadMapOrCacheP;
import com.hazelcast.jet.impl.util.FixedCapacityIntArrayList;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.map.impl.iterator.MapEntriesWithCursor;
import com.hazelcast.partition.PartitioningStrategy;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class SpecificPartitionsImapReaderPms<F extends CompletableFuture, B, R>
extends ReadMapOrCacheP.LocalProcessorMetaSupplier<F, B, R> {
    transient int[] partitionsToScan;
    private final List<List<Expression<?>>> requiredPartitionsExprs;
    private final PartitioningStrategy<?> partitioningStrategy;
    private transient Map<Address, int[]> partitionAssignment;

    private SpecificPartitionsImapReaderPms(BiFunctionEx<HazelcastInstance, InternalSerializationService, ReadMapOrCacheP.Reader<F, B, R>> readerSupplier, @Nullable PartitioningStrategy<?> partitioningStrategy, @Nullable List<List<Expression<?>>> requiredPartitionsExprs) {
        super(readerSupplier);
        this.partitioningStrategy = partitioningStrategy;
        this.requiredPartitionsExprs = requiredPartitionsExprs;
    }

    public void init(@Nonnull ProcessorMetaSupplier.Context context) throws Exception {
        super.init(context);
        if (this.requiredPartitionsExprs != null) {
            FixedCapacityIntArrayList partitionsToScanList = new FixedCapacityIntArrayList(this.requiredPartitionsExprs.size());
            HazelcastInstance hazelcastInstance = context.hazelcastInstance();
            ExpressionEvalContext eec = ExpressionEvalContext.from(context);
            for (List<Expression<?>> requiredPartitionsExpr : this.requiredPartitionsExprs) {
                Object[] partitionKeyComponents = new Object[requiredPartitionsExpr.size()];
                int i = 0;
                for (Expression<?> expression : requiredPartitionsExpr) {
                    partitionKeyComponents[i++] = expression.evalTop(null, eec);
                }
                Integer partitionId = PartitioningStrategyUtil.getPartitionIdFromKeyComponents((NodeEngine)Util.getNodeEngine((HazelcastInstance)hazelcastInstance), this.partitioningStrategy, (Object[])partitionKeyComponents);
                if (partitionId == null) {
                    return;
                }
                assert (context.partitionAssignment().values().stream().anyMatch(pa -> Arrays.binarySearch(pa, partitionId) >= 0)) : "Partition calculated for PMS is not present in the job";
                partitionsToScanList.add(partitionId.intValue());
            }
            this.partitionsToScan = partitionsToScanList.stream().sorted().distinct().toArray();
            this.partitionAssignment = context.partitionAssignment();
        }
    }

    @Nonnull
    public Function<Address, ProcessorSupplier> get(@Nonnull List<Address> addresses) {
        if (this.partitionsToScan == null) {
            return address -> new ReadMapOrCacheP.LocalProcessorSupplier((BiFunction)this.readerSupplier);
        }
        return address -> {
            int[] partitions = this.partitionAssignment.get(address);
            ArrayList<Integer> partitionsToScanList = new ArrayList<Integer>();
            for (int pId : this.partitionsToScan) {
                if (Arrays.binarySearch(partitions, pId) < 0) continue;
                partitionsToScanList.add(pId);
            }
            int[] memberPartitionsToScan = partitionsToScanList.stream().mapToInt(i -> i).toArray();
            return new ReadMapOrCacheP.LocalProcessorSupplier((BiFunction)this.readerSupplier, memberPartitionsToScan);
        };
    }

    public boolean isReusable() {
        return this.requiredPartitionsExprs == null;
    }

    public boolean initIsCooperative() {
        return this.requiredPartitionsExprs == null ? super.initIsCooperative() : this.requiredPartitionsExprs.stream().allMatch(l -> l.stream().allMatch(Expression::isCooperative));
    }

    public static ProcessorMetaSupplier mapReader(final String mapName, @Nullable PartitioningStrategy<?> partitioningStrategy, @Nullable List<List<Expression<?>>> requiredPartitionsExprs) {
        return new SpecificPartitionsImapReaderPms<InternalCompletableFuture<MapEntriesWithCursor>, MapEntriesWithCursor, Map.Entry<Data, Data>>((BiFunctionEx)new HazelcastReaders.LocalMapReaderFunction(mapName), partitioningStrategy, requiredPartitionsExprs){

            public Permission getRequiredPermission() {
                return new MapPermission(mapName, new String[]{"create", "read"});
            }
        };
    }
}

