/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadata;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataResolver;
import com.hazelcast.jet.sql.impl.extract.HazelcastJsonQueryTargetDescriptor;
import com.hazelcast.jet.sql.impl.inject.HazelcastJsonUpsertTargetDescriptor;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

final class MetadataJsonResolver
implements KvMetadataResolver {
    static final MetadataJsonResolver INSTANCE = new MetadataJsonResolver();

    private MetadataJsonResolver() {
    }

    @Override
    public Stream<String> supportedFormats() {
        return Stream.of("json-flat");
    }

    @Override
    public Stream<MappingField> resolveAndValidateFields(boolean isKey, List<MappingField> userFields, Map<String, String> options, InternalSerializationService serializationService) {
        if (userFields.isEmpty()) {
            throw QueryException.error((String)"Column list is required for JSON format");
        }
        return KvMetadataResolver.extractFields(userFields, isKey).entrySet().stream().map(entry -> {
            QueryPath path = (QueryPath)entry.getKey();
            if (path.isTopLevel()) {
                throw QueryException.error((String)("Cannot use '" + String.valueOf(path) + "' field with JSON serialization"));
            }
            return (MappingField)entry.getValue();
        });
    }

    @Override
    public KvMetadata resolveMetadata(boolean isKey, List<MappingField> resolvedFields, Map<String, String> options, InternalSerializationService serializationService) {
        Map<QueryPath, MappingField> externalFieldsByPath = KvMetadataResolver.extractFields(resolvedFields, isKey);
        ArrayList<TableField> fields = new ArrayList<TableField>();
        for (Map.Entry<QueryPath, MappingField> entry : externalFieldsByPath.entrySet()) {
            QueryPath path = entry.getKey();
            QueryDataType type = entry.getValue().type();
            String name = entry.getValue().name();
            fields.add(new MapTableField(name, type, false, path));
        }
        KvMetadataResolver.maybeAddDefaultField(isKey, resolvedFields, fields, QueryDataType.OBJECT);
        return new KvMetadata(fields, HazelcastJsonQueryTargetDescriptor.INSTANCE, HazelcastJsonUpsertTargetDescriptor.INSTANCE);
    }
}

