/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.storage;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.vector.VectorCollectionConfig;
import com.hazelcast.config.vector.VectorIndexConfig;
import com.hazelcast.internal.memory.Measurable;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.SerializationServiceAware;
import com.hazelcast.internal.util.JVMUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.Storage;
import com.hazelcast.map.impl.recordstore.StorageImpl;
import com.hazelcast.map.impl.recordstore.expiry.ExpirySystem;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.shaded.io.github.jbellis.jvector.vector.types.VectorFloat;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergeTypes;
import com.hazelcast.vector.SearchOptions;
import com.hazelcast.vector.SearchResult;
import com.hazelcast.vector.SearchResults;
import com.hazelcast.vector.VectorDocument;
import com.hazelcast.vector.VectorValues;
import com.hazelcast.vector.impl.DataVectorDocument;
import com.hazelcast.vector.impl.Hints;
import com.hazelcast.vector.impl.InternalSearchResult;
import com.hazelcast.vector.impl.VectorUtil;
import com.hazelcast.vector.impl.stats.OnDemandStats;
import com.hazelcast.vector.impl.stats.OnDemandStatsImpl;
import com.hazelcast.vector.impl.stats.VectorIndexStats;
import com.hazelcast.vector.impl.stats.VectorIndexStatsImpl;
import com.hazelcast.vector.impl.storage.AbstractVectorIndex;
import com.hazelcast.vector.impl.storage.ArrayVectorProvider;
import com.hazelcast.vector.impl.storage.ConcurrentModificationPolicy;
import com.hazelcast.vector.impl.storage.ReplicationStateHolder;
import com.hazelcast.vector.impl.storage.SimpleVectorRecord;
import com.hazelcast.vector.impl.storage.VectorCollectionObjectProvider;
import com.hazelcast.vector.impl.storage.VectorIndexFactory;
import java.io.IOException;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class VectorCollectionStorage
implements Measurable {
    public static final Object NOT_LOCKED = new Object();
    private static final long FIXED_HEAP_BYTES_USED = (long)JVMUtil.OBJECT_HEADER_SIZE + 7L * (long)JVMUtil.REFERENCE_COST_IN_BYTES + 8L + 1L;
    private static final int MAX_CONCURRENT_MODIFICATION_RETRIES = 3;
    protected final ILogger logger;
    private final NodeEngine nodeEngine;
    private final VectorCollectionConfig config;
    private final String name;
    private final Storage<Data, Record<Data>> recordStore;
    private final VectorCollectionObjectProvider.VectorFloatConverter vectorConverter;
    private final int partitionId;
    private final boolean binaryMetadataFormat;
    private final VectorIndexHolder vectorIndexes;
    private volatile int logicalTime;

    public VectorCollectionStorage(NodeEngine nodeEngine, String name, int partitionId, VectorCollectionConfig config, VectorCollectionObjectProvider memoryObjectProvider) {
        this.nodeEngine = nodeEngine;
        this.logger = nodeEngine.getLogger(VectorCollectionStorage.class);
        this.config = config;
        this.name = name;
        this.partitionId = partitionId;
        this.recordStore = new StorageImpl<Record<Data>>(InMemoryFormat.BINARY, ExpirySystem.NULL, nodeEngine.getSerializationService());
        this.binaryMetadataFormat = true;
        this.vectorIndexes = new VectorIndexHolder(config.getVectorIndexConfigs());
        this.vectorConverter = memoryObjectProvider.createVectorFloatConverter();
    }

    public String getName() {
        return this.name;
    }

    public VectorCollectionConfig getConfig() {
        return this.config;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public VectorDocument<Data> put(Data keyData, Data userValue, VectorValues vectorValues) {
        this.checkMutatingOperationAllowed();
        this.validateVectors(vectorValues);
        DataVectorDocument oldDocument = null;
        Record<Data> oldRecord = this.recordStore.get(keyData);
        Data oldValue = null;
        if (oldRecord == null) {
            this.recordStore.put(keyData, this.createRecord(userValue));
        } else {
            oldValue = oldRecord.getValue();
            this.updateRecordVersion(oldRecord);
            this.recordStore.updateRecordValue(keyData, oldRecord, userValue);
        }
        VectorValues oldVectors = this.putVectorsReturningPrevious(keyData, vectorValues);
        assert (oldRecord == null && oldVectors == null || oldRecord != null && oldVectors != null) : "Record store inconsistent with vector index";
        if (oldRecord != null) {
            this.updateRecordVersion(oldRecord);
            oldDocument = new DataVectorDocument(oldValue, oldVectors);
        }
        return oldDocument;
    }

    public VectorDocument<Data> putIfAbsent(Data keyData, Data userValue, VectorValues vectorValues) {
        this.checkMutatingOperationAllowed();
        this.validateVectors(vectorValues);
        VectorDocument<Data> oldValue = this.get(keyData);
        if (oldValue != null) {
            return oldValue;
        }
        this.recordStore.put(keyData, this.createRecord(userValue));
        this.putVectors(keyData, vectorValues);
        return null;
    }

    public void set(Data keyData, Data userValue, VectorValues vectorValues) {
        this.checkMutatingOperationAllowed();
        this.validateVectors(vectorValues);
        Record<Data> currentRecord = this.recordStore.get(keyData);
        if (currentRecord == null) {
            this.recordStore.put(keyData, this.createRecord(userValue));
            this.putVectors(keyData, vectorValues);
        } else {
            this.updateRecordVersion(currentRecord);
            this.recordStore.updateRecordValue(keyData, currentRecord, userValue);
            this.putVectors(keyData, vectorValues);
            this.updateRecordVersion(currentRecord);
        }
    }

    private Record<Data> createRecord(Data userValue) {
        return new SimpleVectorRecord<Data>(userValue, this.logicalTime);
    }

    private void updateRecordVersion(Record<?> record) {
        int currentTime = this.logicalTime;
        record.setVersion(currentTime + 1);
        this.logicalTime = currentTime + 1;
    }

    private void advanceLogicalTime() {
        int currentTime = this.logicalTime;
        this.logicalTime = currentTime + 2;
    }

    private int getSearchLogicalTime() {
        int currentTime = this.logicalTime;
        return currentTime & 0xFFFFFFFE;
    }

    private void validateVectors(VectorValues vectorValues) {
        if (vectorValues instanceof VectorValues.SingleVectorValues) {
            VectorValues.SingleVectorValues svv = (VectorValues.SingleVectorValues)vectorValues;
            if (this.vectorIndexes.isMultiIndex()) {
                throw new IllegalArgumentException("Collection has " + this.vectorIndexes.getSize() + " indexes, cannot put a single vector");
            }
            this.vectorIndexes.getSingleIndex().validateVector(svv.vector());
        } else if (vectorValues instanceof VectorValues.MultiIndexVectorValues) {
            VectorValues.MultiIndexVectorValues mvv = (VectorValues.MultiIndexVectorValues)vectorValues;
            if (this.vectorIndexes.getSize() != mvv.indexNameToVector().size()) {
                throw new IllegalArgumentException("Collection has " + this.vectorIndexes.getSize() + " indexes, cannot put " + mvv.indexNameToVector().size() + " vectors");
            }
            List<String> notExistsIndexes = mvv.indexNameToVector().keySet().stream().filter(index -> !this.vectorIndexes.doesIndexExist((String)index)).toList();
            if (!notExistsIndexes.isEmpty()) {
                throw new IllegalArgumentException("Invalid vector names specified, the collection does not contain the requested indexes: " + String.valueOf(notExistsIndexes));
            }
            mvv.indexNameToVector().forEach((name, vector) -> this.vectorIndexes.getIndex((String)name).validateVector((float[])vector));
        }
    }

    private void putVectors(Data keyData, VectorValues vectorValues) {
        if (vectorValues instanceof VectorValues.SingleVectorValues) {
            VectorValues.SingleVectorValues svv = (VectorValues.SingleVectorValues)vectorValues;
            this.vectorIndexes.getSingleIndex().put(keyData, this.vectorConverter.toVectorFloat(svv.vector()));
        } else if (vectorValues instanceof VectorValues.MultiIndexVectorValues) {
            VectorValues.MultiIndexVectorValues mvv = (VectorValues.MultiIndexVectorValues)vectorValues;
            mvv.indexNameToVector().forEach((key, value) -> this.vectorIndexes.getIndex((String)key).put(keyData, this.vectorConverter.toVectorFloat((float[])value)));
        } else {
            throw new UnsupportedOperationException("Unsupported VectorValues type");
        }
    }

    @Nullable
    private VectorValues putVectorsReturningPrevious(Data keyData, VectorValues vectorValues) {
        if (vectorValues instanceof VectorValues.SingleVectorValues) {
            VectorValues.SingleVectorValues svv = (VectorValues.SingleVectorValues)vectorValues;
            VectorFloat<?> previous = this.vectorIndexes.getSingleIndex().put(keyData, this.vectorConverter.toVectorFloat(svv.vector()), true);
            return previous != null ? this.onlyVector(previous) : null;
        }
        if (vectorValues instanceof VectorValues.MultiIndexVectorValues) {
            VectorValues.MultiIndexVectorValues mvv = (VectorValues.MultiIndexVectorValues)vectorValues;
            Map<String, float[]> previousVectors = mvv.indexNameToVector().entrySet().stream().map(entry -> {
                VectorFloat<?> previous = this.vectorIndexes.getIndex((String)entry.getKey()).put(keyData, this.vectorConverter.toVectorFloat((float[])entry.getValue()), true);
                return previous != null ? Map.entry((String)entry.getKey(), this.vectorConverter.toFloatArray(previous)) : null;
            }).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            assert (previousVectors.isEmpty() || previousVectors.size() == this.vectorIndexes.getSize()) : "Inconsistent vector indexes, key was present only in " + previousVectors.size();
            return !previousVectors.isEmpty() ? VectorValues.of(previousVectors) : null;
        }
        throw new UnsupportedOperationException("Unsupported VectorValues type");
    }

    public VectorDocument<Data> get(Data key) {
        Data value = this.getInternal(key);
        if (value == null) {
            return null;
        }
        VectorValues vectorValues = this.getVectorValues(key);
        return new DataVectorDocument(value, vectorValues);
    }

    private VectorValues getVectorValues(Data key) {
        VectorValues vectorValues;
        if (!this.vectorIndexes.isMultiIndex()) {
            vectorValues = this.onlyVector(this.vectorIndexes.getSingleIndex().get(key));
        } else {
            HashMap<String, float[]> vectors = new HashMap<String, float[]>(this.vectorIndexes.getSize());
            this.vectorIndexes.forEachIndex(index -> vectors.put(index.indexName, this.vectorConverter.toFloatArray(index.get(key))));
            vectorValues = VectorValues.of(vectors);
        }
        return vectorValues;
    }

    public boolean delete(Data key) {
        this.checkMutatingOperationAllowed();
        Record<Data> oldRecord = this.recordStore.get(key);
        if (oldRecord != null) {
            this.recordStore.removeRecord(key, oldRecord);
            this.vectorIndexes.forEachIndex(vectorIndex -> {
                boolean deleted = vectorIndex.delete(key);
                assert (deleted) : "Inconsistent vector indexes, key was not present in " + vectorIndex.indexName;
            });
            this.advanceLogicalTime();
        }
        return oldRecord != null;
    }

    public VectorDocument<Data> remove(Data key) {
        this.checkMutatingOperationAllowed();
        VectorDocument<Data> oldValue = this.get(key);
        if (oldValue != null) {
            this.delete(key);
        }
        return oldValue;
    }

    public void optimize(String indexName) {
        this.vectorIndexes.validateAndGetIndex(indexName).cleanup();
    }

    private Data getInternal(Data key) {
        Record<Data> record = this.recordStore.get(key);
        return record != null ? record.getValue() : null;
    }

    private Data getInternal(Data key, int readLogicalTime) {
        Record<Data> record = this.recordStore.get(key);
        if (record == null) {
            return null;
        }
        Data value = record.getValue();
        if (record.getVersion() > readLogicalTime) {
            return null;
        }
        return value;
    }

    private VectorValues onlyVector(VectorFloat<?> value) {
        String name = this.vectorIndexes.getSingleIndex().indexName;
        float[] vector = this.vectorConverter.toFloatArray(value);
        return name != null ? VectorValues.of(name, vector) : VectorValues.of(vector);
    }

    private VectorFloat<?> convertToOnHeapArrayVectorFloat(float[] vector) {
        return ArrayVectorProvider.getInstance().createFloatVector(vector);
    }

    public SearchResults<Data, Data> search(VectorValues vectors, SearchOptions searchOptions) {
        for (int attempt = 0; attempt < 2; ++attempt) {
            try {
                return this.doSearch(vectors, searchOptions, ConcurrentModificationPolicy.THROW);
            }
            catch (ConcurrentModificationException cme) {
                this.logger.fine("Search attempt " + attempt + " failed", cme);
                continue;
            }
        }
        return this.doSearch(vectors, searchOptions, ConcurrentModificationPolicy.SKIP);
    }

    private SearchResults<Data, Data> doSearch(VectorValues vectors, SearchOptions searchOptions, ConcurrentModificationPolicy cmPolicy) {
        Iterator<SearchResult<Data, Data>> it;
        VectorValues.MultiIndexVectorValues multiIndexVectorValues;
        VectorFloat<?> searchVectorFloat;
        AbstractVectorIndex index;
        if (vectors instanceof VectorValues.SingleVectorValues) {
            VectorValues.SingleVectorValues singleVectorValues = (VectorValues.SingleVectorValues)vectors;
            if (this.vectorIndexes.isMultiIndex()) {
                throw new IllegalArgumentException("Index must be selected for collection with more than 1 index");
            }
            index = this.vectorIndexes.getSingleIndex();
            searchVectorFloat = this.convertToOnHeapArrayVectorFloat(singleVectorValues.vector());
        } else if (vectors instanceof VectorValues.MultiIndexVectorValues && (multiIndexVectorValues = (VectorValues.MultiIndexVectorValues)vectors).indexNameToVector().size() == 1) {
            Map.Entry<String, float[]> entry = multiIndexVectorValues.indexNameToVector().entrySet().iterator().next();
            String indexName = entry.getKey();
            index = this.vectorIndexes.getIndex(indexName);
            if (index == null) {
                throw new IllegalArgumentException("No vector index named '" + indexName + "' is defined");
            }
            searchVectorFloat = this.convertToOnHeapArrayVectorFloat(entry.getValue());
        } else {
            throw new UnsupportedOperationException("Cannot search multiple vector indexes");
        }
        int limit = this.getPartitionLimit(searchOptions);
        int rerank = this.getEfSearch(index, searchOptions, limit);
        int searchLogicalTime = this.getSearchLogicalTime();
        int searchIndexLogicalTime = index.getSearchLogicalTime();
        SearchResults<Data, Data> results = index.search(searchVectorFloat, limit, rerank, cmPolicy);
        if (searchOptions.isIncludeValue()) {
            it = results.results();
            while (it.hasNext()) {
                this.fillValue(it, cmPolicy, searchLogicalTime);
            }
        }
        if (searchOptions.isIncludeVectors()) {
            it = results.results();
            while (it.hasNext()) {
                this.fillVector(index, it, cmPolicy);
            }
            if (index.getSearchLogicalTime() != searchIndexLogicalTime) {
                it = results.results();
                while (it.hasNext()) {
                    cmPolicy.action(it);
                    it.next();
                }
            }
        }
        return results;
    }

    public String validateAndGetIndexName(String indexName) {
        return this.vectorIndexes.validateAndGetIndex((String)indexName).indexName;
    }

    public void lockIndexMutation(String indexName, UUID uuid) {
        this.vectorIndexes.validateAndGetIndex(indexName).lockIndexMutation(uuid);
    }

    public void unlockIndexMutation(String indexName) {
        this.vectorIndexes.validateAndGetIndex(indexName).unlockIndexMutation();
    }

    private void checkMutatingOperationAllowed() {
        this.vectorIndexes.forEachIndex(AbstractVectorIndex::checkMutatingOperationAllowed);
    }

    public Object findLockedIndex() {
        AbstractVectorIndex lockedIndex = this.vectorIndexes.findLockedIndex();
        return lockedIndex != null ? lockedIndex.indexName : NOT_LOCKED;
    }

    public boolean isIndexLocked(String indexName) {
        return !this.vectorIndexes.validateAndGetIndex(indexName).isMutatingOperationAllowed();
    }

    public void clear() {
        this.checkMutatingOperationAllowed();
        this.vectorIndexes.clear();
        this.recordStore.clear(false);
    }

    public long size() {
        return this.recordStore.size();
    }

    public boolean isEmpty() {
        return this.recordStore.isEmpty();
    }

    public OnDemandStats getOnDemandStats() {
        return new OnDemandStatsImpl(this.size(), this.heapBytesUsed());
    }

    public VectorIndexStats getVectorIndexStats() {
        return this.vectorIndexes.getVectorIndexStats();
    }

    private int getPartitionLimit(SearchOptions searchOptions) {
        int resultLimit = searchOptions.getLimit();
        Integer maybePartitionLimit = Hints.PARTITION_LIMIT.get(searchOptions);
        if (maybePartitionLimit == null) {
            return resultLimit;
        }
        if (maybePartitionLimit < 0) {
            throw new IllegalArgumentException("Partition limit cannot be negative");
        }
        if (maybePartitionLimit > resultLimit) {
            throw new IllegalArgumentException("Number of neighbours requested from partition is greater than requested result size");
        }
        if (maybePartitionLimit * this.nodeEngine.getPartitionService().getPartitionCount() < resultLimit) {
            throw new IllegalArgumentException("Number of neighbours requested from partition is not sufficient to generate full requested result");
        }
        return maybePartitionLimit;
    }

    private int getEfSearch(AbstractVectorIndex index, SearchOptions searchOptions, int limit) {
        Integer maybeEfSearch = Hints.EF_SEARCH.get(searchOptions);
        if (maybeEfSearch == null) {
            return limit;
        }
        if (maybeEfSearch < limit) {
            throw new IllegalArgumentException(String.format("efSearch (%d) is smaller than the number of neighbours requested from partition (%d). If you specified %s hint, it has to have value at least %d. If you specified both %s and %s hints, they have to meet the requirements.", maybeEfSearch, limit, Hints.EF_SEARCH.name(), limit, Hints.EF_SEARCH.name(), Hints.PARTITION_LIMIT.name()));
        }
        return maybeEfSearch;
    }

    private void fillValue(Iterator<? extends SearchResult<Data, Data>> it, ConcurrentModificationPolicy cmPolicy, int searchLogicalTime) {
        InternalSearchResult result = (InternalSearchResult)it.next();
        Data value = this.getInternal((Data)result.getKey(), searchLogicalTime);
        if (value == null) {
            cmPolicy.action(it);
        } else {
            result.setValue(value);
        }
    }

    private void fillVector(AbstractVectorIndex index, Iterator<? extends SearchResult<?, ?>> it, ConcurrentModificationPolicy cmPolicy) {
        InternalSearchResult result = (InternalSearchResult)it.next();
        VectorFloat<?> vector = index.vectorsSupplier.getVector(result.id());
        if (vector == null) {
            cmPolicy.action(it);
        } else {
            VectorValues singleVectorValues = this.vectorConverter.createSingleVectorValue(vector);
            result.setVectors(singleVectorValues);
        }
    }

    VectorIndexHolder getVectorIndexes() {
        return this.vectorIndexes;
    }

    Storage<Data, Record<Data>> getRecordStore() {
        return this.recordStore;
    }

    public void prepareForMigration() {
        this.vectorIndexes.forEachIndex(index -> index.prepareForMigration(this, this.nodeEngine));
    }

    void resetState(ReplicationStateHolder.CollectionReplicationStateHolder state) {
        if (!state.config.equals(this.config)) {
            throw new IllegalArgumentException("Incoming vector collection partition has different configuration");
        }
        if (state.indexes.size() != this.vectorIndexes.getSize()) {
            throw new IllegalStateException("Number of configured indexes (" + this.vectorIndexes.getSize() + ") is not equal to number of received indexes (" + state.indexes.size() + ")");
        }
        assert (this.recordStore.isEmpty()) : "Migration to non-empty storage";
        state.entries.forEach((key, value) -> this.recordStore.put((Data)key, this.createRecord((Data)value)));
        state.indexes.forEach(indexState -> this.vectorIndexes.validateAndGetIndex(indexState.getName()).resetState((ReplicationStateHolder.CollectionReplicationStateHolder.IndexReplicationStateHolder)indexState));
    }

    @Override
    public long heapBytesUsed() {
        return FIXED_HEAP_BYTES_USED + this.vectorIndexes.heapBytesUsed() + this.recordStore.getEntryCostEstimator().getEstimate();
    }

    public void consumeAll(BiConsumer<Integer, SplitBrainMergeTypes.VectorCollectionMergeTypes<Object, VectorDocument<?>>> consumer) {
        Iterator<Map.Entry<Data, Record<Data>>> iterator = this.recordStore.mutationTolerantIterator();
        while (iterator.hasNext()) {
            Map.Entry<Data, Record<Data>> entry = iterator.next();
            VectorCollectionMergingEntryImpl mergingEntry = new VectorCollectionMergingEntryImpl(this.nodeEngine.getSerializationService(), entry.getKey(), entry.getValue().getValue(), this.getVectorValues(entry.getKey()));
            consumer.accept(this.partitionId, mergingEntry);
        }
    }

    public MergeResponse merge(SplitBrainMergeTypes.VectorCollectionMergeTypes<Object, VectorDocument<?>> mergingEntry, SplitBrainMergePolicy<VectorDocument<?>, SplitBrainMergeTypes.VectorCollectionMergeTypes<Object, VectorDocument<?>>, Object> policy) {
        Data dataKey = (Data)mergingEntry.getRawKey();
        VectorDocument<Data> vectorDocument = this.get(dataKey);
        VectorCollectionMergingEntryImpl existingMergingEntry = vectorDocument == null ? null : new VectorCollectionMergingEntryImpl(this.nodeEngine.getSerializationService(), dataKey, vectorDocument);
        VectorDocument mergedDocument = (VectorDocument)policy.merge(mergingEntry, existingMergingEntry);
        if (mergedDocument != null) {
            if (existingMergingEntry != null && mergedDocument.equals(vectorDocument)) {
                return MergeResponse.NO_MERGE_APPLIED;
            }
            this.set(dataKey, this.nodeEngine.toData(mergedDocument.getValue()), mergedDocument.getVectors());
            return new MergeResponse(MergeStatus.ENTRY_UPDATED, mergedDocument);
        }
        if (existingMergingEntry != null) {
            this.delete(dataKey);
            return MergeResponse.ENTRY_REMOVED;
        }
        return MergeResponse.NO_MERGE_APPLIED;
    }

    static class VectorIndexHolder
    implements Measurable {
        private static final long FIXED_HEAP_BYTES_USED = (long)JVMUtil.OBJECT_HEADER_SIZE + 3L * (long)JVMUtil.REFERENCE_COST_IN_BYTES + 4L;
        private final Map<String, AbstractVectorIndex> vectorIndexMap;
        private final int size;
        private final String singleIndexName;
        private final List<VectorIndexConfig> indexConfigs;

        private VectorIndexHolder(List<VectorIndexConfig> indexConfigs) {
            this.indexConfigs = indexConfigs;
            this.size = indexConfigs.size();
            this.singleIndexName = this.size == 1 ? indexConfigs.get(0).getName() : null;
            this.vectorIndexMap = new HashMap<String, AbstractVectorIndex>();
            this.initIndexMap(indexConfigs);
        }

        private void initIndexMap(List<VectorIndexConfig> indexConfigs) {
            for (VectorIndexConfig indexConfig : indexConfigs) {
                this.vectorIndexMap.put(indexConfig.getName(), VectorIndexFactory.create(indexConfig));
            }
        }

        public int getSize() {
            return this.size;
        }

        public boolean isMultiIndex() {
            return this.size > 1;
        }

        public boolean doesIndexExist(String indexName) {
            return this.vectorIndexMap.containsKey(indexName);
        }

        public void forEachIndex(Consumer<AbstractVectorIndex> action) {
            this.vectorIndexMap.values().forEach(action);
        }

        public AbstractVectorIndex findLockedIndex() {
            return this.vectorIndexMap.values().stream().filter(Predicate.not(AbstractVectorIndex::isMutatingOperationAllowed)).findAny().orElse(null);
        }

        public AbstractVectorIndex getIndex(String indexName) {
            assert (indexName != null) : "the index name has not been specified.";
            return this.vectorIndexMap.get(indexName);
        }

        public AbstractVectorIndex getSingleIndex() {
            assert (!this.isMultiIndex()) : "not permitted for use with a multi-index holder.";
            return this.vectorIndexMap.get(this.singleIndexName);
        }

        public AbstractVectorIndex validateAndGetIndex(String indexName) {
            if (this.isMultiIndex()) {
                if (indexName == null) {
                    throw new IllegalArgumentException("The index name has not been specified.");
                }
                AbstractVectorIndex vectorIndex = this.vectorIndexMap.get(indexName);
                if (vectorIndex == null) {
                    throw new IllegalArgumentException("No index was found with the name: " + indexName);
                }
                return vectorIndex;
            }
            if (indexName != null && !indexName.equals(this.singleIndexName)) {
                throw new IllegalArgumentException("No index was found with the name: " + indexName);
            }
            return this.getSingleIndex();
        }

        public void clear() {
            this.initIndexMap(this.indexConfigs);
        }

        @Override
        public long heapBytesUsed() {
            long heapBytesUsed = FIXED_HEAP_BYTES_USED + (long)this.vectorIndexMap.size() * (long)JVMUtil.REFERENCE_COST_IN_BYTES;
            for (AbstractVectorIndex index : this.vectorIndexMap.values()) {
                heapBytesUsed += index.heapBytesUsed();
            }
            return heapBytesUsed;
        }

        public VectorIndexStats getVectorIndexStats() {
            if (this.isMultiIndex()) {
                VectorIndexStatsImpl stats = new VectorIndexStatsImpl();
                this.forEachIndex(index -> stats.add(index.getStats()));
                return stats;
            }
            return this.getSingleIndex().getStats();
        }
    }

    public static final class VectorCollectionMergingEntryImpl<K, V extends VectorDocument<?>>
    implements SplitBrainMergeTypes.VectorCollectionMergeTypes<K, V>,
    IdentifiedDataSerializable,
    SerializationServiceAware {
        private transient SerializationService serializationService;
        private Data key;
        private VectorDocument<Data> vectorDocument;

        public VectorCollectionMergingEntryImpl() {
        }

        public VectorCollectionMergingEntryImpl(SerializationService serializationService, Data key, VectorDocument<Data> vectorDocument) {
            this.serializationService = serializationService;
            this.key = key;
            this.vectorDocument = vectorDocument;
        }

        public VectorCollectionMergingEntryImpl(SerializationService serializationService, Data key, Data value, VectorValues vectorValues) {
            this.serializationService = serializationService;
            this.key = key;
            this.vectorDocument = new DataVectorDocument(value, vectorValues);
        }

        @Override
        public K getKey() {
            return (K)this.serializationService.toObject(this.key);
        }

        @Override
        public Data getRawKey() {
            return this.key;
        }

        @Override
        public V getDeserializedValue() {
            return (V)VectorUtil.deserialize(this.vectorDocument, this.serializationService);
        }

        @Override
        public VectorDocument<Data> getRawValue() {
            return this.vectorDocument;
        }

        @Override
        public int getFactoryId() {
            return -100;
        }

        @Override
        public int getClassId() {
            return 35;
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            IOUtil.writeData(out, this.key);
            out.writeObject(this.vectorDocument);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.key = IOUtil.readData(in);
            this.vectorDocument = (VectorDocument)in.readObject();
        }

        @Override
        public void setSerializationService(SerializationService serializationService) {
            this.serializationService = serializationService;
        }
    }

    public record MergeResponse(MergeStatus status, VectorDocument<?> mergedValue) {
        public static final MergeResponse NO_MERGE_APPLIED = new MergeResponse(MergeStatus.NO_MERGE_APPLIED, null);
        public static final MergeResponse ENTRY_REMOVED = new MergeResponse(MergeStatus.ENTRY_REMOVED, null);
    }

    public static enum MergeStatus {
        NO_MERGE_APPLIED,
        ENTRY_REMOVED,
        ENTRY_UPDATED;

    }
}

