/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.stats;

import com.hazelcast.internal.tpcengine.util.ReflectionUtil;
import com.hazelcast.internal.util.JVMUtil;
import com.hazelcast.vector.impl.stats.VectorIndexStats;
import java.lang.invoke.VarHandle;
import java.util.Objects;

public class VectorIndexStatsImpl
implements VectorIndexStats {
    public static final long FIXED_HEAP_BYTES_USED = JVMUtil.OBJECT_HEADER_SIZE + 16;
    private static final VarHandle QUERY_COUNT = ReflectionUtil.findVarHandle("queryCount", Long.TYPE);
    private static final VarHandle VISITED_NODES = ReflectionUtil.findVarHandle("visitedNodes", Long.TYPE);
    private volatile long queryCount;
    private volatile long visitedNodes;

    @Override
    public long getQueryCount() {
        return this.queryCount;
    }

    public void incrementQueryCount() {
        QUERY_COUNT.setOpaque(this, this.queryCount + 1L);
    }

    @Override
    public long getVisitedNodes() {
        return this.visitedNodes;
    }

    public void addVisitedNodes(int nodes) {
        VISITED_NODES.setOpaque(this, this.visitedNodes + (long)nodes);
    }

    public VectorIndexStats add(VectorIndexStats other) {
        QUERY_COUNT.setOpaque(this, this.queryCount + other.getQueryCount());
        VISITED_NODES.setOpaque(this, this.visitedNodes + other.getVisitedNodes());
        return this;
    }

    public void set(VectorIndexStats other) {
        this.queryCount = other.getQueryCount();
        this.visitedNodes = other.getVisitedNodes();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VectorIndexStatsImpl that = (VectorIndexStatsImpl)o;
        return this.queryCount == that.queryCount && this.visitedNodes == that.visitedNodes;
    }

    public int hashCode() {
        return Objects.hash(this.queryCount, this.visitedNodes);
    }
}

