/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.stats;

import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.tpcengine.util.ReflectionUtil;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.JVMUtil;
import com.hazelcast.internal.util.TimeUtil;
import com.hazelcast.vector.impl.stats.LocalVectorCollectionStats;
import com.hazelcast.vector.impl.stats.VectorIndexStats;
import com.hazelcast.vector.impl.stats.VectorIndexStatsImpl;
import java.lang.invoke.VarHandle;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class LocalVectorCollectionStatsImpl
implements LocalVectorCollectionStats {
    static final long FIXED_HEAP_BYTES_USED = JVMUtil.OBJECT_HEADER_SIZE + 4 + 304;
    private static final VarHandle LAST_ACCESS_TIME = ReflectionUtil.findVarHandle("lastAccessTime", Long.TYPE);
    private static final VarHandle LAST_UPDATE_TIME = ReflectionUtil.findVarHandle("lastUpdateTime", Long.TYPE);
    private static final AtomicLongFieldUpdater<LocalVectorCollectionStatsImpl> GET_COUNT = AtomicLongFieldUpdater.newUpdater(LocalVectorCollectionStatsImpl.class, "getCount");
    private static final AtomicLongFieldUpdater<LocalVectorCollectionStatsImpl> PUT_COUNT = AtomicLongFieldUpdater.newUpdater(LocalVectorCollectionStatsImpl.class, "putCount");
    private static final AtomicLongFieldUpdater<LocalVectorCollectionStatsImpl> PUT_ALL_COUNT = AtomicLongFieldUpdater.newUpdater(LocalVectorCollectionStatsImpl.class, "putAllCount");
    private static final AtomicLongFieldUpdater<LocalVectorCollectionStatsImpl> PUT_ALL_ENTRY_COUNT = AtomicLongFieldUpdater.newUpdater(LocalVectorCollectionStatsImpl.class, "putAllEntryCount");
    private static final AtomicLongFieldUpdater<LocalVectorCollectionStatsImpl> SET_COUNT = AtomicLongFieldUpdater.newUpdater(LocalVectorCollectionStatsImpl.class, "setCount");
    private static final AtomicLongFieldUpdater<LocalVectorCollectionStatsImpl> REMOVE_COUNT = AtomicLongFieldUpdater.newUpdater(LocalVectorCollectionStatsImpl.class, "removeCount");
    private static final AtomicLongFieldUpdater<LocalVectorCollectionStatsImpl> DELETE_COUNT = AtomicLongFieldUpdater.newUpdater(LocalVectorCollectionStatsImpl.class, "deleteCount");
    private static final AtomicLongFieldUpdater<LocalVectorCollectionStatsImpl> TOTAL_GET_LATENCIES = AtomicLongFieldUpdater.newUpdater(LocalVectorCollectionStatsImpl.class, "totalGetLatenciesNanos");
    private static final AtomicLongFieldUpdater<LocalVectorCollectionStatsImpl> TOTAL_PUT_LATENCIES = AtomicLongFieldUpdater.newUpdater(LocalVectorCollectionStatsImpl.class, "totalPutLatenciesNanos");
    private static final AtomicLongFieldUpdater<LocalVectorCollectionStatsImpl> TOTAL_PUT_ALL_LATENCIES = AtomicLongFieldUpdater.newUpdater(LocalVectorCollectionStatsImpl.class, "totalPutAllLatenciesNanos");
    private static final AtomicLongFieldUpdater<LocalVectorCollectionStatsImpl> TOTAL_SET_LATENCIES = AtomicLongFieldUpdater.newUpdater(LocalVectorCollectionStatsImpl.class, "totalSetLatenciesNanos");
    private static final AtomicLongFieldUpdater<LocalVectorCollectionStatsImpl> TOTAL_REMOVE_LATENCIES = AtomicLongFieldUpdater.newUpdater(LocalVectorCollectionStatsImpl.class, "totalRemoveLatenciesNanos");
    private static final AtomicLongFieldUpdater<LocalVectorCollectionStatsImpl> TOTAL_DELETE_LATENCIES = AtomicLongFieldUpdater.newUpdater(LocalVectorCollectionStatsImpl.class, "totalDeleteLatenciesNanos");
    private static final VarHandle MAX_GET_LATENCY = ReflectionUtil.findVarHandle("maxGetLatency", Long.TYPE);
    private static final VarHandle MAX_PUT_LATENCY = ReflectionUtil.findVarHandle("maxPutLatency", Long.TYPE);
    private static final VarHandle MAX_PUT_ALL_LATENCY = ReflectionUtil.findVarHandle("maxPutAllLatency", Long.TYPE);
    private static final VarHandle MAX_SET_LATENCY = ReflectionUtil.findVarHandle("maxSetLatency", Long.TYPE);
    private static final VarHandle MAX_REMOVE_LATENCY = ReflectionUtil.findVarHandle("maxRemoveLatency", Long.TYPE);
    private static final VarHandle MAX_DELETE_LATENCY = ReflectionUtil.findVarHandle("maxDeleteLatency", Long.TYPE);
    private static final AtomicLongFieldUpdater<LocalVectorCollectionStatsImpl> SEARCH_COUNT = AtomicLongFieldUpdater.newUpdater(LocalVectorCollectionStatsImpl.class, "searchCount");
    private static final AtomicLongFieldUpdater<LocalVectorCollectionStatsImpl> SEARCH_RESULTS_COUNT = AtomicLongFieldUpdater.newUpdater(LocalVectorCollectionStatsImpl.class, "searchResultsCount");
    private static final AtomicLongFieldUpdater<LocalVectorCollectionStatsImpl> TOTAL_SEARCH_LATENCIES = AtomicLongFieldUpdater.newUpdater(LocalVectorCollectionStatsImpl.class, "totalSearchLatenciesNanos");
    private static final VarHandle MAX_SEARCH_LATENCY = ReflectionUtil.findVarHandle("maxSearchLatency", Long.TYPE);
    private static final AtomicLongFieldUpdater<LocalVectorCollectionStatsImpl> OPTIMIZE_COUNT = AtomicLongFieldUpdater.newUpdater(LocalVectorCollectionStatsImpl.class, "optimizeCount");
    private static final AtomicLongFieldUpdater<LocalVectorCollectionStatsImpl> TOTAL_OPTIMIZE_LATENCIES = AtomicLongFieldUpdater.newUpdater(LocalVectorCollectionStatsImpl.class, "totalOptimizeLatenciesNanos");
    private static final VarHandle MAX_OPTIMIZE_LATENCY = ReflectionUtil.findVarHandle("maxOptimizeLatency", Long.TYPE);
    private static final AtomicLongFieldUpdater<LocalVectorCollectionStatsImpl> CLEAR_COUNT = AtomicLongFieldUpdater.newUpdater(LocalVectorCollectionStatsImpl.class, "clearCount");
    private static final AtomicLongFieldUpdater<LocalVectorCollectionStatsImpl> TOTAL_CLEAR_LATENCIES = AtomicLongFieldUpdater.newUpdater(LocalVectorCollectionStatsImpl.class, "totalClearLatenciesNanos");
    private static final VarHandle MAX_CLEAR_LATENCY = ReflectionUtil.findVarHandle("maxClearLatency", Long.TYPE);
    private static final AtomicLongFieldUpdater<LocalVectorCollectionStatsImpl> SIZE_COUNT = AtomicLongFieldUpdater.newUpdater(LocalVectorCollectionStatsImpl.class, "sizeCount");
    private static final AtomicLongFieldUpdater<LocalVectorCollectionStatsImpl> TOTAL_SIZE_LATENCIES = AtomicLongFieldUpdater.newUpdater(LocalVectorCollectionStatsImpl.class, "totalSizeLatenciesNanos");
    private static final VarHandle MAX_SIZE_LATENCY = ReflectionUtil.findVarHandle("maxSizeLatency", Long.TYPE);
    private volatile long lastAccessTime;
    @Probe(name="lastUpdateTime", unit=ProbeUnit.MS)
    private volatile long lastUpdateTime;
    @Probe(name="getCount")
    private volatile long getCount;
    @Probe(name="putCount")
    private volatile long putCount;
    @Probe(name="putAllCount")
    private volatile long putAllCount;
    @Probe(name="putAllEntryCount")
    private volatile long putAllEntryCount;
    @Probe(name="setCount")
    private volatile long setCount;
    @Probe(name="removeCount")
    private volatile long removeCount;
    @Probe(name="deleteCount")
    private volatile long deleteCount;
    private volatile long totalGetLatenciesNanos;
    private volatile long totalPutLatenciesNanos;
    private volatile long totalPutAllLatenciesNanos;
    private volatile long totalSetLatenciesNanos;
    private volatile long totalRemoveLatenciesNanos;
    private volatile long totalDeleteLatenciesNanos;
    private volatile long maxGetLatency;
    private volatile long maxPutLatency;
    private volatile long maxPutAllLatency;
    private volatile long maxSetLatency;
    private volatile long maxRemoveLatency;
    private volatile long maxDeleteLatency;
    @Probe(name="searchCount")
    private volatile long searchCount;
    @Probe(name="searchResultsCount")
    private volatile long searchResultsCount;
    private volatile long totalSearchLatenciesNanos;
    private volatile long maxSearchLatency;
    @Probe(name="optimizeCount")
    private volatile long optimizeCount;
    private volatile long totalOptimizeLatenciesNanos;
    private volatile long maxOptimizeLatency;
    @Probe(name="clearCount")
    private volatile long clearCount;
    private volatile long totalClearLatenciesNanos;
    private volatile long maxClearLatency;
    @Probe(name="sizeCount")
    private volatile long sizeCount;
    private volatile long totalSizeLatenciesNanos;
    private volatile long maxSizeLatency;
    @Probe(name="creationTime", unit=ProbeUnit.MS)
    private final long creationTime;
    @Probe(name="ownedEntryCount")
    private volatile long ownedEntryCount;
    @Probe(name="backupEntryCount")
    private volatile long backupEntryCount;
    @Probe(name="ownedEntryHeapMemoryCost", unit=ProbeUnit.BYTES)
    private volatile long ownedEntryHeapMemoryCost;
    @Probe(name="backupEntryHeapMemoryCost", unit=ProbeUnit.BYTES)
    private volatile long backupEntryHeapMemoryCost;
    @Probe(name="heapCost", unit=ProbeUnit.BYTES)
    private volatile long heapCost;
    @Probe(name="backupCount")
    private volatile int backupCount;
    private final VectorIndexStatsImpl vectorIndexStats = new VectorIndexStatsImpl();

    LocalVectorCollectionStatsImpl() {
        this.creationTime = Clock.currentTimeMillis();
    }

    @Override
    public long getOwnedEntryCount() {
        return this.ownedEntryCount;
    }

    public void setOwnedEntryCount(long ownedEntryCount) {
        this.ownedEntryCount = ownedEntryCount;
    }

    @Override
    public long getBackupEntryCount() {
        return this.backupEntryCount;
    }

    public void setBackupEntryCount(long backupEntryCount) {
        this.backupEntryCount = backupEntryCount;
    }

    @Override
    public int getBackupCount() {
        return this.backupCount;
    }

    public void setBackupCount(int backupCount) {
        this.backupCount = backupCount;
    }

    @Override
    public long getOwnedEntryHeapMemoryCost() {
        return this.ownedEntryHeapMemoryCost;
    }

    public void setOwnedEntryHeapMemoryCost(long ownedEntryHeapMemoryCost) {
        this.ownedEntryHeapMemoryCost = ownedEntryHeapMemoryCost;
    }

    @Override
    public long getBackupEntryHeapMemoryCost() {
        return this.backupEntryHeapMemoryCost;
    }

    public void setBackupEntryHeapMemoryCost(long backupEntryHeapMemoryCost) {
        this.backupEntryHeapMemoryCost = backupEntryHeapMemoryCost;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    @Probe(name="lastAccessTime", unit=ProbeUnit.MS)
    public long getLastAccessTime() {
        return Math.max(this.lastAccessTime, this.lastUpdateTime);
    }

    public void setLastAccessTime(long lastAccessTime) {
        ConcurrencyUtil.setMax(this, LAST_ACCESS_TIME, lastAccessTime);
    }

    @Override
    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        ConcurrencyUtil.setMax(this, LAST_UPDATE_TIME, lastUpdateTime);
    }

    @Override
    public long getPutOperationCount() {
        return this.putCount;
    }

    @Override
    public long getSetOperationCount() {
        return this.setCount;
    }

    @Override
    public long getGetOperationCount() {
        return this.getCount;
    }

    @Override
    public long getRemoveOperationCount() {
        return this.removeCount;
    }

    @Override
    public long getDeleteOperationCount() {
        return this.deleteCount;
    }

    @Override
    @Probe(name="totalPutLatency", unit=ProbeUnit.MS)
    public long getTotalPutLatency() {
        return TimeUtil.convertNanosToMillis(this.totalPutLatenciesNanos);
    }

    @Override
    @Probe(name="totalPutAllLatency", unit=ProbeUnit.MS)
    public long getTotalPutAllLatency() {
        return TimeUtil.convertNanosToMillis(this.totalPutAllLatenciesNanos);
    }

    @Override
    @Probe(name="totalSetLatency", unit=ProbeUnit.MS)
    public long getTotalSetLatency() {
        return TimeUtil.convertNanosToMillis(this.totalSetLatenciesNanos);
    }

    @Override
    @Probe(name="totalGetLatency", unit=ProbeUnit.MS)
    public long getTotalGetLatency() {
        return TimeUtil.convertNanosToMillis(this.totalGetLatenciesNanos);
    }

    @Override
    @Probe(name="totalRemoveLatency", unit=ProbeUnit.MS)
    public long getTotalRemoveLatency() {
        return TimeUtil.convertNanosToMillis(this.totalRemoveLatenciesNanos);
    }

    @Override
    @Probe(name="totalDeleteLatency", unit=ProbeUnit.MS)
    public long getTotalDeleteLatency() {
        return TimeUtil.convertNanosToMillis(this.totalDeleteLatenciesNanos);
    }

    @Override
    @Probe(name="totalMaxPutLatency", unit=ProbeUnit.MS)
    public long getMaxPutLatency() {
        return TimeUtil.convertNanosToMillis(this.maxPutLatency);
    }

    @Override
    @Probe(name="totalMaxPutAllLatency", unit=ProbeUnit.MS)
    public long getMaxPutAllLatency() {
        return TimeUtil.convertNanosToMillis(this.maxPutAllLatency);
    }

    @Override
    @Probe(name="totalMaxSetLatency", unit=ProbeUnit.MS)
    public long getMaxSetLatency() {
        return TimeUtil.convertNanosToMillis(this.maxSetLatency);
    }

    @Override
    @Probe(name="totalMaxGetLatency", unit=ProbeUnit.MS)
    public long getMaxGetLatency() {
        return TimeUtil.convertNanosToMillis(this.maxGetLatency);
    }

    @Override
    @Probe(name="totalMaxRemoveLatency", unit=ProbeUnit.MS)
    public long getMaxRemoveLatency() {
        return TimeUtil.convertNanosToMillis(this.maxRemoveLatency);
    }

    @Override
    @Probe(name="totalMaxDeleteLatency", unit=ProbeUnit.MS)
    public long getMaxDeleteLatency() {
        return TimeUtil.convertNanosToMillis(this.maxDeleteLatency);
    }

    @Override
    public long getHeapCost() {
        return this.heapCost;
    }

    public void setHeapCost(long heapCost) {
        this.heapCost = heapCost;
    }

    public void incrementPutLatencyNanos(long latencyNanos) {
        PUT_COUNT.incrementAndGet(this);
        TOTAL_PUT_LATENCIES.addAndGet(this, latencyNanos);
        ConcurrencyUtil.setMax(this, MAX_PUT_LATENCY, latencyNanos);
        this.onUpdate();
    }

    public void incrementPutAllLatencyNanos(long delta, long latencyNanos) {
        PUT_ALL_COUNT.incrementAndGet(this);
        PUT_ALL_ENTRY_COUNT.addAndGet(this, delta);
        TOTAL_PUT_ALL_LATENCIES.addAndGet(this, latencyNanos);
        ConcurrencyUtil.setMax(this, MAX_PUT_ALL_LATENCY, latencyNanos);
        this.onUpdate();
    }

    public void incrementSetLatencyNanos(long latencyNanos) {
        SET_COUNT.incrementAndGet(this);
        TOTAL_SET_LATENCIES.addAndGet(this, latencyNanos);
        ConcurrencyUtil.setMax(this, MAX_SET_LATENCY, latencyNanos);
        this.onUpdate();
    }

    public void incrementGetLatencyNanos(long latencyNanos) {
        GET_COUNT.incrementAndGet(this);
        TOTAL_GET_LATENCIES.addAndGet(this, latencyNanos);
        ConcurrencyUtil.setMax(this, MAX_GET_LATENCY, latencyNanos);
        this.onAccess();
    }

    public void incrementRemoveLatencyNanos(long latencyNanos) {
        REMOVE_COUNT.incrementAndGet(this);
        TOTAL_REMOVE_LATENCIES.addAndGet(this, latencyNanos);
        ConcurrencyUtil.setMax(this, MAX_REMOVE_LATENCY, latencyNanos);
        this.onUpdate();
    }

    public void incrementDeleteLatencyNanos(long latencyNanos) {
        DELETE_COUNT.incrementAndGet(this);
        TOTAL_DELETE_LATENCIES.addAndGet(this, latencyNanos);
        ConcurrencyUtil.setMax(this, MAX_DELETE_LATENCY, latencyNanos);
        this.onUpdate();
    }

    @Override
    public long getSearchCount() {
        return this.searchCount;
    }

    @Override
    public long getSearchResultsCount() {
        return this.searchResultsCount;
    }

    @Override
    @Probe(name="maxSearchLatency", unit=ProbeUnit.MS)
    public long getMaxSearchLatency() {
        return TimeUtil.convertNanosToMillis(this.maxSearchLatency);
    }

    @Override
    @Probe(name="totalSearchLatency", unit=ProbeUnit.MS)
    public long getTotalSearchLatency() {
        return TimeUtil.convertNanosToMillis(this.totalSearchLatenciesNanos);
    }

    public void incrementSearchLatencyNanos(long resultsCount, long latencyNanos) {
        SEARCH_COUNT.incrementAndGet(this);
        SEARCH_RESULTS_COUNT.addAndGet(this, resultsCount);
        TOTAL_SEARCH_LATENCIES.addAndGet(this, latencyNanos);
        ConcurrencyUtil.setMax(this, MAX_SEARCH_LATENCY, latencyNanos);
        this.onAccess();
    }

    @Override
    @Probe(name="searchIndexQueryCount", unit=ProbeUnit.COUNT)
    public long getSearchIndexQueryCount() {
        return this.vectorIndexStats.getQueryCount();
    }

    @Override
    @Probe(name="searchIndexVisitedNodes", unit=ProbeUnit.COUNT)
    public long getSearchIndexVisitedNodes() {
        return this.vectorIndexStats.getVisitedNodes();
    }

    public void setVectorIndexStats(VectorIndexStats vectorIndexStats) {
        this.vectorIndexStats.set(vectorIndexStats);
    }

    @Override
    public long getOptimizeCount() {
        return this.optimizeCount;
    }

    @Override
    @Probe(name="maxOptimizeLatency", unit=ProbeUnit.MS)
    public long getMaxOptimizeLatency() {
        return TimeUtil.convertNanosToMillis(this.maxOptimizeLatency);
    }

    @Override
    @Probe(name="totalOptimizeLatency", unit=ProbeUnit.MS)
    public long getTotalOptimizeLatency() {
        return TimeUtil.convertNanosToMillis(this.totalOptimizeLatenciesNanos);
    }

    public void incrementOptimizeLatencyNanos(long latencyNanos) {
        OPTIMIZE_COUNT.incrementAndGet(this);
        TOTAL_OPTIMIZE_LATENCIES.addAndGet(this, latencyNanos);
        ConcurrencyUtil.setMax(this, MAX_OPTIMIZE_LATENCY, latencyNanos);
        this.onAccess();
    }

    @Override
    public long getClearCount() {
        return this.clearCount;
    }

    @Override
    @Probe(name="maxClearLatency", unit=ProbeUnit.MS)
    public long getMaxClearLatency() {
        return TimeUtil.convertNanosToMillis(this.maxClearLatency);
    }

    @Override
    @Probe(name="totalClearLatency", unit=ProbeUnit.MS)
    public long getTotalClearLatency() {
        return TimeUtil.convertNanosToMillis(this.totalClearLatenciesNanos);
    }

    public void incrementClearLatencyNanos(long latencyNanos) {
        CLEAR_COUNT.incrementAndGet(this);
        TOTAL_CLEAR_LATENCIES.addAndGet(this, latencyNanos);
        ConcurrencyUtil.setMax(this, MAX_CLEAR_LATENCY, latencyNanos);
        this.onUpdate();
    }

    @Override
    public long getSizeCount() {
        return this.sizeCount;
    }

    @Override
    @Probe(name="maxSizeLatency", unit=ProbeUnit.MS)
    public long getMaxSizeLatency() {
        return TimeUtil.convertNanosToMillis(this.maxSizeLatency);
    }

    @Override
    @Probe(name="totalSizeLatency", unit=ProbeUnit.MS)
    public long getTotalSizeLatency() {
        return TimeUtil.convertNanosToMillis(this.totalSizeLatenciesNanos);
    }

    public void incrementSizeLatencyNanos(long latencyNanos) {
        SIZE_COUNT.incrementAndGet(this);
        TOTAL_SIZE_LATENCIES.addAndGet(this, latencyNanos);
        ConcurrencyUtil.setMax(this, MAX_SIZE_LATENCY, latencyNanos);
        this.onAccess();
    }

    private void onAccess() {
        this.setLastAccessTime(Clock.currentTimeMillis());
    }

    private void onUpdate() {
        this.setLastUpdateTime(Clock.currentTimeMillis());
    }
}

