/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.service;

import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.vector.VectorCollectionConfig;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.merge.AbstractMergeRunnable;
import com.hazelcast.spi.impl.merge.AbstractSplitBrainHandlerService;
import com.hazelcast.spi.impl.operationservice.OperationFactory;
import com.hazelcast.spi.merge.DiscardMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergeTypes;
import com.hazelcast.vector.VectorDocument;
import com.hazelcast.vector.impl.ops.MergeOperationFactory;
import com.hazelcast.vector.impl.service.VectorCollectionServiceImpl;
import com.hazelcast.vector.impl.storage.VectorCollectionStorage;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;

public class VectorCollectionSplitBrainHandlerService
extends AbstractSplitBrainHandlerService<VectorCollectionStorage> {
    private final NodeEngine nodeEngine;

    public VectorCollectionSplitBrainHandlerService(NodeEngine nodeEngine) {
        super(nodeEngine);
        this.nodeEngine = nodeEngine;
    }

    @Override
    protected Runnable newMergeRunnable(Collection<VectorCollectionStorage> mergingStores) {
        return new VectorCollectionMergeRunnable(mergingStores);
    }

    @Override
    protected Iterator<VectorCollectionStorage> storeIterator(int partitionId) {
        return this.getService().storageIterator(partitionId);
    }

    @Override
    protected void destroyStore(VectorCollectionStorage vectorCollectionStorage) {
    }

    @Override
    protected boolean hasEntries(VectorCollectionStorage vectorCollectionStorage) {
        return !vectorCollectionStorage.isEmpty();
    }

    @Override
    protected boolean hasMergeablePolicy(VectorCollectionStorage vectorCollectionStorage) {
        String namespace = vectorCollectionStorage.getConfig().getUserCodeNamespace();
        String policy = vectorCollectionStorage.getConfig().getMergePolicyConfig().getPolicy();
        SplitBrainMergePolicy mergePolicy = this.nodeEngine.getSplitBrainMergePolicyProvider().getMergePolicy(policy, namespace);
        return !(mergePolicy instanceof DiscardMergePolicy);
    }

    VectorCollectionServiceImpl getService() {
        return (VectorCollectionServiceImpl)this.nodeEngine.getService("hz:service:vector");
    }

    class VectorCollectionMergeRunnable
    extends AbstractMergeRunnable<Object, VectorDocument<?>, VectorCollectionStorage, SplitBrainMergeTypes.VectorCollectionMergeTypes<Object, VectorDocument<?>>> {
        VectorCollectionMergeRunnable(Collection<VectorCollectionStorage> mergingStores) {
            super("hz:service:vector", mergingStores, VectorCollectionSplitBrainHandlerService.this, VectorCollectionSplitBrainHandlerService.this.nodeEngine);
        }

        @Override
        protected void mergeStore(VectorCollectionStorage recordStore, BiConsumer<Integer, SplitBrainMergeTypes.VectorCollectionMergeTypes<Object, VectorDocument<?>>> consumer) {
            recordStore.consumeAll(consumer);
        }

        @Override
        protected int getBatchSize(String dataStructureName) {
            return VectorCollectionSplitBrainHandlerService.this.getService().getExistingVectorCollectionConfig(dataStructureName).getMergePolicyConfig().getBatchSize();
        }

        @Override
        protected SplitBrainMergePolicy<VectorDocument<?>, SplitBrainMergeTypes.VectorCollectionMergeTypes<Object, VectorDocument<?>>, Object> getMergePolicy(String dataStructureName) {
            VectorCollectionConfig config = VectorCollectionSplitBrainHandlerService.this.getService().getExistingVectorCollectionConfig(dataStructureName);
            MergePolicyConfig mergePolicyConfig = config.getMergePolicyConfig();
            return this.mergePolicyProvider.getMergePolicy(mergePolicyConfig.getPolicy(), config.getUserCodeNamespace());
        }

        @Override
        protected String getDataStructureName(VectorCollectionStorage vectorCollectionStorage) {
            return vectorCollectionStorage.getName();
        }

        @Override
        protected int getPartitionId(VectorCollectionStorage vectorCollectionStorage) {
            return vectorCollectionStorage.getPartitionId();
        }

        @Override
        protected OperationFactory createMergeOperationFactory(String dataStructureName, SplitBrainMergePolicy<VectorDocument<?>, SplitBrainMergeTypes.VectorCollectionMergeTypes<Object, VectorDocument<?>>, Object> mergePolicy, int[] partitions, List<SplitBrainMergeTypes.VectorCollectionMergeTypes<Object, VectorDocument<?>>>[] entries) {
            return new MergeOperationFactory(dataStructureName, partitions, entries, mergePolicy);
        }
    }
}

