/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.service;

import com.hazelcast.internal.util.JVMUtil;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationexecutor.OperationExecutor;
import com.hazelcast.vector.impl.VectorCollectionOptimizationManager;
import com.hazelcast.vector.impl.ops.VectorOptimizeWaitNotifyKey;
import com.hazelcast.vector.impl.service.VectorCollectionServiceImpl;
import java.util.concurrent.Semaphore;

public class VectorCollectionOptimizationManagerImpl
implements VectorCollectionOptimizationManager {
    public static final long FIXED_HEAP_BYTES_USED = (long)JVMUtil.OBJECT_HEADER_SIZE + 3L * (long)JVMUtil.REFERENCE_COST_IN_BYTES + (long)JVMUtil.OBJECT_HEADER_SIZE;
    private final NodeEngine nodeEngine;
    private final Semaphore optimizationPermits;
    private final VectorOptimizeWaitNotifyKey[] optimizationWaitNotifyKeys;

    public VectorCollectionOptimizationManagerImpl(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        int maxConcurrentOptimize = nodeEngine.getProperties().getInteger(VectorCollectionServiceImpl.MAX_CONCURRENT_OPTIMIZE);
        this.optimizationPermits = new Semaphore(maxConcurrentOptimize);
        int threadCount = nodeEngine.getOperationService().getPartitionThreadCount();
        this.optimizationWaitNotifyKeys = new VectorOptimizeWaitNotifyKey[threadCount];
        for (int i = 0; i < threadCount; ++i) {
            this.optimizationWaitNotifyKeys[i] = new VectorOptimizeWaitNotifyKey(i);
        }
    }

    @Override
    public boolean tryAcquireOptimizationPermit() {
        return this.optimizationPermits.tryAcquire();
    }

    @Override
    public boolean hasAvailableOptimizationPermit() {
        return this.optimizationPermits.availablePermits() > 0;
    }

    @Override
    public void releaseOptimizationPermit() {
        this.optimizationPermits.release();
    }

    @Override
    public VectorOptimizeWaitNotifyKey getOptimizePartitionWaitNotifyKey(int partitionId) {
        int threadId = this.getOperationExecutor().getPartitionThreadId(partitionId);
        return this.getOptimizeWaitNotifyKey(threadId);
    }

    @Override
    public VectorOptimizeWaitNotifyKey getOptimizeWaitNotifyKey(int threadId) {
        return this.optimizationWaitNotifyKeys[threadId];
    }

    private OperationExecutor getOperationExecutor() {
        return this.nodeEngine.getOperationService().getOperationExecutor();
    }

    @Override
    public long heapBytesUsed() {
        return FIXED_HEAP_BYTES_USED + (long)this.optimizationWaitNotifyKeys.length * VectorOptimizeWaitNotifyKey.FIXED_HEAP_BYTES_USED;
    }
}

