/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.protocol.task.dynamicconfig;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.DynamicConfigAddVectorCollectionConfigCodec;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.AbstractAddConfigMessageTask;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.vector.VectorCollectionConfig;
import com.hazelcast.config.vector.VectorIndexConfig;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.dynamicconfig.DynamicConfigurationAwareConfig;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.security.permission.UserCodeNamespacePermission;
import java.security.Permission;

public class AddVectorCollectionConfigMessageTask
extends AbstractAddConfigMessageTask<DynamicConfigAddVectorCollectionConfigCodec.RequestParameters> {
    public AddVectorCollectionConfigMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected DynamicConfigAddVectorCollectionConfigCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return DynamicConfigAddVectorCollectionConfigCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return DynamicConfigAddVectorCollectionConfigCodec.encodeResponse();
    }

    @Override
    protected IdentifiedDataSerializable getConfig() {
        VectorCollectionConfig config = new VectorCollectionConfig();
        config.setName(((DynamicConfigAddVectorCollectionConfigCodec.RequestParameters)this.parameters).name);
        config.setBackupCount(((DynamicConfigAddVectorCollectionConfigCodec.RequestParameters)this.parameters).backupCount);
        config.setAsyncBackupCount(((DynamicConfigAddVectorCollectionConfigCodec.RequestParameters)this.parameters).asyncBackupCount);
        config.setSplitBrainProtectionName(((DynamicConfigAddVectorCollectionConfigCodec.RequestParameters)this.parameters).splitBrainProtectionName);
        config.setUserCodeNamespace(((DynamicConfigAddVectorCollectionConfigCodec.RequestParameters)this.parameters).userCodeNamespace);
        if (((DynamicConfigAddVectorCollectionConfigCodec.RequestParameters)this.parameters).isMergeBatchSizeExists && ((DynamicConfigAddVectorCollectionConfigCodec.RequestParameters)this.parameters).isMergePolicyExists) {
            config.setMergePolicyConfig(new MergePolicyConfig(((DynamicConfigAddVectorCollectionConfigCodec.RequestParameters)this.parameters).mergePolicy, ((DynamicConfigAddVectorCollectionConfigCodec.RequestParameters)this.parameters).mergeBatchSize));
        }
        for (VectorIndexConfig indexConfig : ((DynamicConfigAddVectorCollectionConfigCodec.RequestParameters)this.parameters).indexConfigs) {
            config.addVectorIndexConfig(indexConfig);
        }
        return config;
    }

    @Override
    public String getMethodName() {
        return "addVectorCollectionConfig";
    }

    @Override
    public Permission getUserCodeNamespacePermission() {
        return ((DynamicConfigAddVectorCollectionConfigCodec.RequestParameters)this.parameters).userCodeNamespace != null ? new UserCodeNamespacePermission(((DynamicConfigAddVectorCollectionConfigCodec.RequestParameters)this.parameters).userCodeNamespace, "use") : null;
    }

    @Override
    protected boolean checkStaticConfigDoesNotExist(IdentifiedDataSerializable config) {
        DynamicConfigurationAwareConfig nodeConfig = (DynamicConfigurationAwareConfig)this.nodeEngine.getConfig();
        VectorCollectionConfig vectorCollectionConfig = (VectorCollectionConfig)config;
        return DynamicConfigurationAwareConfig.checkStaticConfigDoesNotExist(nodeConfig.getStaticConfig().getVectorCollectionConfigs(), vectorCollectionConfig.getName(), vectorCollectionConfig);
    }
}

