/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.ops;

import com.hazelcast.config.vector.VectorCollectionConfig;
import com.hazelcast.internal.config.MergePolicyValidator;
import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.BackupAwareOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.PartitionAwareOperation;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergeTypes;
import com.hazelcast.vector.VectorDocument;
import com.hazelcast.vector.impl.DataVectorDocument;
import com.hazelcast.vector.impl.VectorCollectionService;
import com.hazelcast.vector.impl.VectorUtil;
import com.hazelcast.vector.impl.ops.BaseMutatingOperation;
import com.hazelcast.vector.impl.ops.MergeBackupOperation;
import com.hazelcast.vector.impl.ops.VectorEntries;
import com.hazelcast.vector.impl.storage.VectorCollectionStorage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MergeOperation
extends BaseMutatingOperation
implements PartitionAwareOperation,
BackupAwareOperation {
    private List<SplitBrainMergeTypes.VectorCollectionMergeTypes<Object, VectorDocument<?>>> mergingEntries;
    private SplitBrainMergePolicy<VectorDocument<?>, SplitBrainMergeTypes.VectorCollectionMergeTypes<Object, VectorDocument<?>>, Object> mergePolicy;
    private transient VectorEntries updatedEntries;
    private transient List<Data> removedKeys;
    private transient boolean hasBackupsConfigured;
    private transient VectorCollectionConfig config;

    public MergeOperation() {
    }

    public MergeOperation(String name, List<SplitBrainMergeTypes.VectorCollectionMergeTypes<Object, VectorDocument<?>>> mergingEntries, SplitBrainMergePolicy<VectorDocument<?>, SplitBrainMergeTypes.VectorCollectionMergeTypes<Object, VectorDocument<?>>, Object> mergePolicy) {
        super(name);
        this.mergingEntries = mergingEntries;
        this.mergePolicy = mergePolicy;
    }

    @Override
    public void beforeRun() {
        super.beforeRun();
        this.config = this.storage.getConfig();
        MergePolicyValidator.checkVectorCollectionMergePolicy(this.config, this.config.getMergePolicyConfig().getPolicy(), this.getNodeEngine().getSplitBrainMergePolicyProvider());
        this.hasBackupsConfigured = this.config.getTotalBackupCount() > 0;
        this.updatedEntries = this.hasBackupsConfigured ? new VectorEntries() : null;
        this.removedKeys = this.hasBackupsConfigured ? new ArrayList(this.mergingEntries.size()) : null;
    }

    @Override
    public void run() throws Exception {
        for (SplitBrainMergeTypes.VectorCollectionMergeTypes<Object, VectorDocument<?>> entry : this.mergingEntries) {
            VectorCollectionStorage.MergeResponse mergeResponse = this.storage.merge(entry, this.mergePolicy);
            if (!this.hasBackupsConfigured) continue;
            if (mergeResponse == VectorCollectionStorage.MergeResponse.ENTRY_REMOVED) {
                this.removedKeys.add((Data)entry.getRawKey());
                continue;
            }
            if (mergeResponse.status() != VectorCollectionStorage.MergeStatus.ENTRY_UPDATED) continue;
            DataVectorDocument dataVectorDocument = VectorUtil.serialize(mergeResponse.mergedValue(), this.getNodeEngine().getSerializationService());
            this.updatedEntries.add((Data)entry.getRawKey(), dataVectorDocument);
        }
    }

    @Override
    public boolean shouldBackup() {
        return this.hasBackupsConfigured && (!this.updatedEntries.isEmpty() || !this.removedKeys.isEmpty());
    }

    @Override
    public int getSyncBackupCount() {
        return this.config.getBackupCount();
    }

    @Override
    public int getAsyncBackupCount() {
        return this.config.getAsyncBackupCount();
    }

    @Override
    public Operation getBackupOperation() {
        return new MergeBackupOperation(this.name, this.updatedEntries, this.removedKeys);
    }

    @Override
    public int getClassId() {
        return 37;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        SerializationUtil.writeList(this.mergingEntries, out);
        out.writeObject(this.mergePolicy);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.mergingEntries = SerializationUtil.readList(in);
        this.mergePolicy = NamespaceUtil.callWithNamespace(in::readObject, this.name, VectorCollectionService::lookupNamespace);
    }
}

