/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.ops;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.vector.impl.ops.PutAllBackupOperation;
import com.hazelcast.vector.impl.ops.VectorEntries;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;

public class MergeBackupOperation
extends PutAllBackupOperation {
    private List<Data> removedKeys;

    public MergeBackupOperation() {
    }

    public MergeBackupOperation(String name, VectorEntries vectorEntries, @Nonnull List<Data> removedKeys) {
        super(name, vectorEntries);
        this.removedKeys = removedKeys;
    }

    @Override
    public void run() throws Exception {
        this.putAll();
        if (this.removedKeys != null) {
            for (Data key : this.removedKeys) {
                this.storage.delete(key);
            }
        }
        if (this.backupOpAfterRun != null) {
            this.backupOpAfterRun.accept(this);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        SerializationUtil.writeList(this.removedKeys, out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.removedKeys = SerializationUtil.readList(in);
    }

    @Override
    public int getClassId() {
        return 38;
    }
}

