/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.ops;

import com.hazelcast.internal.partition.PartitionMigrationEvent;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import com.hazelcast.spi.impl.operationservice.BlockingBackupOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.vector.impl.ops.BaseDeleteOperation;
import java.util.function.Consumer;

public class DeleteBackupOperation
extends BaseDeleteOperation
implements BackupOperation,
BlockingBackupOperation {
    private transient Consumer<Operation> backupOpAfterRun;

    public DeleteBackupOperation() {
    }

    public DeleteBackupOperation(String vectorCollectionName, Data key) {
        super(vectorCollectionName, key);
    }

    @Override
    public void run() throws Exception {
        if (this.storage != null) {
            this.storage.delete(this.key);
        }
        if (this.backupOpAfterRun != null) {
            this.backupOpAfterRun.accept(this);
        }
    }

    @Override
    public int getClassId() {
        return 32;
    }

    @Override
    public void setBackupOpAfterRun(Consumer<Operation> backupOpAfterRun) {
        this.backupOpAfterRun = backupOpAfterRun;
    }

    @Override
    public boolean shouldKeepAfterMigration(PartitionMigrationEvent event) {
        return event.getNewReplicaIndex() <= this.storage.getConfig().getTotalBackupCount();
    }
}

