/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.ops;

import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.internal.services.ServiceNamespaceAware;
import com.hazelcast.internal.util.Timer;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationexecutor.OperationExecutor;
import com.hazelcast.spi.impl.operationexecutor.impl.PartitionOperationThread;
import com.hazelcast.spi.impl.operationparker.OperationParker;
import com.hazelcast.spi.impl.operationservice.AbstractNamedOperation;
import com.hazelcast.spi.impl.operationservice.BlockingOperation;
import com.hazelcast.spi.impl.operationservice.CallStatus;
import com.hazelcast.spi.impl.operationservice.Offload;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.PartitionAwareOperation;
import com.hazelcast.spi.impl.operationservice.WaitNotifyKey;
import com.hazelcast.vector.impl.VectorCollectionOptimizationManager;
import com.hazelcast.vector.impl.VectorCollectionService;
import com.hazelcast.vector.impl.ops.BackupUtil;
import com.hazelcast.vector.impl.ops.VectorMutationWaitNotifyKey;
import com.hazelcast.vector.impl.ops.VectorOptimizeWaitNotifyKey;
import com.hazelcast.vector.impl.storage.VectorCollectionStorage;
import java.io.IOException;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public abstract class BaseOptimizeOperation
extends AbstractNamedOperation
implements PartitionAwareOperation,
ServiceNamespaceAware,
BlockingOperation {
    protected UUID uuid;
    protected String indexName;
    @Nullable
    protected transient VectorCollectionStorage storage;
    @Nullable
    protected transient Consumer<Operation> backupOpAfterRun;
    protected transient boolean waited;
    @Nullable
    protected transient String actualIndexName;

    protected BaseOptimizeOperation() {
    }

    protected BaseOptimizeOperation(UUID uuid, String vectorCollectionName, String indexName) {
        super(vectorCollectionName);
        this.uuid = uuid;
        this.indexName = indexName;
    }

    @Override
    public void beforeRun() {
        this.storage = this.getVectorCollectionService().getStorageOrNull(this.name, this.getPartitionId());
        this.actualIndexName = this.storage != null ? this.storage.validateAndGetIndexName(this.indexName) : null;
    }

    @Override
    public CallStatus call() throws Exception {
        if (this.storage == null) {
            return CallStatus.RESPONSE;
        }
        if (this.storage.isIndexLocked(this.indexName)) {
            if (this.waited) {
                this.getLogger().fine("Moving to the end of the queue because the index is locked: %s", this);
            }
            this.getLogger().finest("Index is locked, waiting with key %s, operation %s", this.getWaitKey(), this);
            this.waited = true;
            return CallStatus.WAIT;
        }
        if (!this.getOptimizationManager().tryAcquireOptimizationPermit()) {
            if (this.waited) {
                this.getLogger().fine("Moving to the end of the queue because did not get permit: %s", this);
            }
            this.getLogger().finest("Did not get permit, waiting with key %s, operation %s", this.getWaitKey(), this);
            this.waited = true;
            return CallStatus.WAIT;
        }
        this.getLogger().finest("Got permit %s", this);
        if (this.waited) {
            this.getLogger().finest("Executing after waiting %s", this);
        }
        return new IndexOptimizeOffloaded();
    }

    @Override
    public WaitNotifyKey getWaitKey() {
        return this.getOptimizationManager().getOptimizePartitionWaitNotifyKey(this.getPartitionId());
    }

    @Override
    public boolean shouldWait() {
        return this.storage.isIndexLocked(this.indexName) || !this.getOptimizationManager().hasAvailableOptimizationPermit();
    }

    @Override
    public void onWaitExpire() {
        this.sendResponse(new OperationTimeoutException("Timeout elapsed while waiting for index to be unlocked"));
    }

    @Override
    public String getServiceName() {
        return "hz:service:vector";
    }

    @Override
    public int getFactoryId() {
        return -100;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        UUIDSerializationUtil.writeUUID(out, this.uuid);
        out.writeString(this.indexName);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.uuid = UUIDSerializationUtil.readUUID(in);
        this.indexName = in.readString();
    }

    @Override
    public ObjectNamespace getServiceNamespace() {
        return this.getVectorCollectionService().getObjectNamespace(this.getName());
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", uuid=").append(this.uuid).append(", indexName=").append(this.indexName).append(", actualIndexName=").append(this.actualIndexName);
    }

    private void notifyAfterOptimization() {
        int operationThreadId = this.getOperationExecutor().getPartitionThreadId(this.getPartitionId());
        ILogger logger = this.getLogger();
        this.getOperationExecutor().executeOnPartitionThreads(() -> {
            OperationParker operationParker = ((NodeEngineImpl)this.getNodeEngine()).getOperationParker();
            int threadId = ((PartitionOperationThread)Thread.currentThread()).getThreadId();
            if (threadId == operationThreadId) {
                VectorMutationWaitNotifyKey mutationWaitNotifyKey = new VectorMutationWaitNotifyKey(this.getName(), this.actualIndexName, this.getPartitionId());
                logger.finest("Notifying %s from partitionId=%d", mutationWaitNotifyKey, this.getPartitionId());
                operationParker.unpark(mutationWaitNotifyKey);
            }
            VectorOptimizeWaitNotifyKey optimizationWaitNotifyKey = this.getOptimizationManager().getOptimizeWaitNotifyKey(threadId);
            logger.finest("Notifying %s from partitionId=%d", optimizationWaitNotifyKey, this.getPartitionId());
            operationParker.unpark(optimizationWaitNotifyKey);
        });
    }

    private VectorCollectionService getVectorCollectionService() {
        return (VectorCollectionService)this.getService();
    }

    private VectorCollectionOptimizationManager getOptimizationManager() {
        return this.getVectorCollectionService().getOptimizationManager();
    }

    private OperationExecutor getOperationExecutor() {
        return this.getNodeEngine().getOperationService().getOperationExecutor();
    }

    private final class IndexOptimizeOffloaded
    extends Offload {
        private IndexOptimizeOffloaded() {
            super(BaseOptimizeOperation.this);
        }

        @Override
        public void start() {
            BaseOptimizeOperation.this.storage.lockIndexMutation(BaseOptimizeOperation.this.indexName, BaseOptimizeOperation.this.uuid);
            ILogger logger = BaseOptimizeOperation.this.getLogger();
            logger.finest("Locked index for %s", BaseOptimizeOperation.this);
            long blocked = Timer.nanos();
            this.nodeEngine.getExecutionService().execute("hz:offloadable", () -> {
                try {
                    try {
                        long start = Timer.nanos();
                        BaseOptimizeOperation.this.storage.optimize(BaseOptimizeOperation.this.indexName);
                        long elapsed = Timer.millisElapsed(start);
                        logger.fine("Optimization on index %s collection %s partitionId=%d took %d ms ", BaseOptimizeOperation.this.actualIndexName, BaseOptimizeOperation.this.name, BaseOptimizeOperation.this.getPartitionId(), elapsed);
                    }
                    finally {
                        BaseOptimizeOperation.this.storage.unlockIndexMutation(BaseOptimizeOperation.this.indexName);
                        long blockedMs = Timer.millisElapsed(blocked);
                        logger.fine("Index %s on collection %s partitionId=%d was blocked for %d ms ", BaseOptimizeOperation.this.actualIndexName, BaseOptimizeOperation.this.name, BaseOptimizeOperation.this.getPartitionId(), blockedMs);
                        BaseOptimizeOperation.this.getOptimizationManager().releaseOptimizationPermit();
                        BaseOptimizeOperation.this.notifyAfterOptimization();
                    }
                    BackupUtil.handleBackupAndSendResponse(BaseOptimizeOperation.this);
                    if (BaseOptimizeOperation.this.backupOpAfterRun != null) {
                        BaseOptimizeOperation.this.backupOpAfterRun.accept(BaseOptimizeOperation.this);
                    }
                }
                catch (Throwable t) {
                    BaseOptimizeOperation.this.onExecutionFailure(t);
                    BaseOptimizeOperation.this.sendResponse(t);
                }
            });
        }
    }
}

