/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl.ops;

import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.partition.PartitionReplicaVersionManager;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.spi.impl.operationexecutor.OperationRunner;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.spi.impl.operationservice.impl.OperationRunnerImpl;

final class BackupUtil {
    private BackupUtil() {
    }

    public static void handleBackupAndSendResponse(Operation op) {
        assert (op.getPartitionId() != -1);
        OperationService operationService = op.getNodeEngine().getOperationService();
        OperationRunner runner = operationService.getOperationExecutor().getPartitionOperationRunners()[op.getPartitionId()];
        ((OperationRunnerImpl)runner).sendBackupsAndResponse(op);
    }

    public static void markReplicaAsSyncRequiredForBackupOps(Operation operation) {
        assert (operation instanceof BackupOperation) : "Should be invoked only for backup operations";
        PartitionReplicaVersionManager versionManager = BackupUtil.getPartitionReplicaVersionManager(operation);
        int partitionId = operation.getPartitionId();
        ServiceNamespace namespace = versionManager.getServiceNamespace(operation);
        int replicaIndex = operation.getReplicaIndex();
        versionManager.markPartitionReplicaAsSyncRequired(partitionId, namespace, replicaIndex);
    }

    private static PartitionReplicaVersionManager getPartitionReplicaVersionManager(Operation operation) {
        InternalPartitionService partitionService = (InternalPartitionService)operation.getNodeEngine().getPartitionService();
        return partitionService.getPartitionReplicaVersionManager();
    }
}

