/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.vector.SearchResult;
import com.hazelcast.vector.SearchResults;
import com.hazelcast.vector.VectorDocument;
import com.hazelcast.vector.impl.DataVectorDocument;
import com.hazelcast.vector.impl.InternalSearchResult;
import com.hazelcast.vector.impl.SearchResultImpl;
import com.hazelcast.vector.impl.SearchResultsImpl;
import java.util.ArrayList;
import java.util.Iterator;

public class VectorUtil {
    private VectorUtil() {
    }

    public static <V> DataVectorDocument serialize(VectorDocument<V> vectorDocument, SerializationService serializationService) {
        if (vectorDocument instanceof DataVectorDocument) {
            DataVectorDocument dataVectorDocument = (DataVectorDocument)vectorDocument;
            return dataVectorDocument;
        }
        if (vectorDocument == null) {
            return null;
        }
        Object valueData = serializationService.toData(vectorDocument.getValue());
        return new DataVectorDocument((Data)valueData, vectorDocument.getVectors());
    }

    public static <V> VectorDocument<V> deserialize(VectorDocument<Data> dataVectorDocument, SerializationService serializationService) {
        if (dataVectorDocument == null) {
            return null;
        }
        Object userValue = serializationService.toObject(dataVectorDocument.getValue());
        return VectorDocument.of(userValue, dataVectorDocument.getVectors());
    }

    public static <K, V> SearchResults<K, V> deserialize(SearchResults<Data, Data> dataSearchResults, SerializationService serializationService) {
        ArrayList results = new ArrayList(dataSearchResults.size());
        Iterator<SearchResult<Data, Data>> it = dataSearchResults.results();
        while (it.hasNext()) {
            InternalSearchResult r = (InternalSearchResult)it.next();
            results.add(((SearchResultImpl)new SearchResultImpl(r.id(), serializationService.toObject(r.getKey()), r.getScore()).setValue(serializationService.toObject(r.getValue()))).setVectors(r.getVectors()));
        }
        return new SearchResultsImpl(results);
    }
}

