/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl;

import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.hotrestart.cluster.ClusterHotRestartEventListener;
import com.hazelcast.internal.hotrestart.cluster.HotRestartClusterStartStatus;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.sql.impl.DataConnectionConsistencyChecker;
import java.util.Set;
import java.util.UUID;

public class SqlClusterHotRestartEventListener
extends ClusterHotRestartEventListener {
    private final Node node;
    private final ILogger logger;

    public SqlClusterHotRestartEventListener(Node node) {
        this.node = node;
        this.logger = node.getLogger(this.getClass());
    }

    @Override
    public void onHotRestartDataLoadComplete(HotRestartClusterStartStatus result, Set<UUID> excludedMemberUuids) {
        if (result != HotRestartClusterStartStatus.CLUSTER_START_SUCCEEDED) {
            return;
        }
        if (excludedMemberUuids.contains(this.node.getThisUuid())) {
            return;
        }
        if (!this.sqlCatalogExists()) {
            return;
        }
        NodeEngineImpl nodeEngine = this.node.getNodeEngine();
        DataConnectionConsistencyChecker checker = new DataConnectionConsistencyChecker(nodeEngine.getHazelcastInstance(), (NodeEngine)nodeEngine);
        try {
            checker.init();
            checker.check();
        }
        catch (Exception e) {
            this.logger.warning("Data Connection consistency check failed: ", e);
        }
    }

    private boolean sqlCatalogExists() {
        MapService mapService = (MapService)this.node.getNodeEngine().getService("hz:impl:mapService");
        return mapService.getMapServiceContext().getMapContainers().get("__sql.catalog") != null;
    }
}

