/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.securestore.impl;

import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.VaultSecureStoreConfig;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.json.Json;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.json.JsonValue;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ssl.BasicSSLContextFactory;
import com.hazelcast.nio.ssl.SSLContextFactory;
import com.hazelcast.spi.impl.securestore.SecureStoreException;
import com.hazelcast.spi.impl.securestore.impl.AbstractSecureStore;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;

public class VaultSecureStore
extends AbstractSecureStore {
    private final VaultClient client;

    VaultSecureStore(@Nonnull VaultSecureStoreConfig config, @Nonnull Node node) {
        super(config.getPollingInterval(), node);
        this.client = new VaultClient(config, node.getConfigClassLoader(), this.logger);
    }

    @Override
    @Nonnull
    public List<byte[]> retrieveEncryptionKeys() {
        return this.client.retrieveEncryptionKeys();
    }

    @Override
    protected Runnable getWatcher() {
        return new VaultWatcher();
    }

    private static final class VaultClient {
        private static final int CONNECTION_TIMEOUT_MILLIS = 30000;
        private static final String HEADER_TOKEN = "X-Vault-Token";
        private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
        private final VaultSecureStoreConfig config;
        private final ClassLoader classLoader;
        private final ILogger logger;

        private VaultClient(@Nonnull VaultSecureStoreConfig config, ClassLoader classLoader, @Nonnull ILogger logger) {
            this.config = config;
            this.classLoader = classLoader;
            this.logger = logger;
        }

        @Nonnull
        List<byte[]> retrieveEncryptionKeys() {
            try {
                String mountPath = this.getMountPath();
                Range range = this.readVersionRange(mountPath);
                ArrayList<byte[]> keys = new ArrayList<byte[]>(range.max - range.min + 1);
                for (int version = range.max; version >= range.min; --version) {
                    byte[] key = this.readKey(mountPath, version);
                    if (key == null) continue;
                    keys.add(key);
                }
                return keys;
            }
            catch (Exception e) {
                this.logger.warning("Failed to retrieve encryption keys", e);
                throw new SecureStoreException("Failed to retrieve encryption keys", e);
            }
        }

        private byte[] retrieveCurrentEncryptionKey() {
            try {
                String mountPath = this.getMountPath();
                return this.readKey(mountPath, 0);
            }
            catch (Exception e) {
                this.logger.warning("Failed to retrieve encryption keys", e);
                throw new SecureStoreException("Failed to retrieve the current encryption key", e);
            }
        }

        private byte[] readKey(String mountPath, int version) throws Exception {
            String requestUrl = String.format("%s/v1/%s?version=%d", this.config.getAddress(), VaultClient.secretPath(this.config.getSecretPath(), mountPath, false), version);
            Response response = this.doGet(requestUrl);
            if (response.statusCode == 404) {
                return null;
            }
            if (response.statusCode != 200) {
                throw new SecureStoreException("Unexpected response: " + String.valueOf(response));
            }
            return VaultClient.parseKeyResponse(response, mountPath != null);
        }

        private Range readVersionRange(String mountPath) throws Exception {
            if (mountPath == null) {
                return new Range(0, 0);
            }
            String secretPath = VaultClient.secretPath(this.config.getSecretPath(), mountPath, true);
            String requestUrl = String.format("%s/v1/%s", this.config.getAddress(), secretPath);
            Response response = this.doGet(requestUrl);
            if (response.statusCode == 404) {
                this.logger.warning("No key metadata found at secret path: " + secretPath);
                return new Range(0, 0);
            }
            if (response.statusCode != 200) {
                throw new SecureStoreException("Unexpected response: " + String.valueOf(response));
            }
            return VaultClient.parseVersionResponse(response);
        }

        private static Range parseVersionResponse(Response response) {
            String jsonString = new String(response.body, StandardCharsets.UTF_8);
            JsonObject jsonObject = Json.parse(jsonString).asObject();
            jsonObject = jsonObject.get("data").asObject();
            int min = 1;
            int max = 0;
            for (JsonObject.Member member : jsonObject) {
                String memberName = member.getName();
                if ("oldest_version".equals(memberName)) {
                    min = Math.max(VaultClient.intValue(member), 1);
                    continue;
                }
                if (!"current_version".equals(memberName)) continue;
                max = VaultClient.intValue(member);
            }
            if (max == 0) {
                throw new SecureStoreException("Failed to parse version range: " + String.valueOf(response));
            }
            return new Range(min, max);
        }

        private static int intValue(JsonObject.Member member) {
            JsonValue jsonValue = member.getValue();
            if (jsonValue != null && jsonValue.isNumber()) {
                return jsonValue.asInt();
            }
            return 0;
        }

        private static byte[] parseKeyResponse(Response response, boolean kvV2) {
            String jsonString = new String(response.body, StandardCharsets.UTF_8);
            JsonObject jsonObject = Json.parse(jsonString).asObject();
            jsonObject = jsonObject.get("data").asObject();
            if (kvV2) {
                jsonObject = jsonObject.get("data").asObject();
            }
            String value = null;
            for (JsonObject.Member member : jsonObject) {
                if (value != null) {
                    throw new SecureStoreException("Multiple key/value mappings found under secret path");
                }
                JsonValue jsonValue = member.getValue();
                if (jsonValue == null || jsonValue.isNull()) continue;
                value = jsonValue.isString() ? jsonValue.asString() : jsonValue.toString();
            }
            return value == null ? null : VaultClient.decodeKey(value);
        }

        private static byte[] decodeKey(String base64Value) {
            try {
                return Base64.getDecoder().decode(base64Value.trim());
            }
            catch (Exception e) {
                throw new SecureStoreException("Failed to Base64-decode encryption key", e);
            }
        }

        private String getMountPath() throws Exception {
            String requestUrl = String.format("%s/v1/sys/internal/ui/mounts/%s", this.config.getAddress(), this.config.getSecretPath());
            Response response = this.doGet(requestUrl);
            if (response.statusCode == 404) {
                this.logger.fine("The Vault /sys/internal/ui/mounts endpoint not found, assuming V1");
                return null;
            }
            if (response.statusCode != 200) {
                throw new SecureStoreException("Failed to determine the secrets engine mount path for secret path: " + this.config.getSecretPath() + ": " + String.valueOf(response));
            }
            return VaultClient.parseMountsResponse(response);
        }

        private static String parseMountsResponse(Response response) {
            String jsonString = new String(response.body, StandardCharsets.UTF_8);
            JsonObject jsonObject = Json.parse(jsonString).asObject();
            String type = (jsonObject = jsonObject.get("data").asObject()).getString("type", null);
            if (!"kv".equals(type)) {
                throw new SecureStoreException("Unsupported secrets engine type: " + type);
            }
            JsonObject options = jsonObject.get("options").asObject();
            String version = options.getString("version", "0");
            if (!"2".equals(version)) {
                return null;
            }
            return jsonObject.getString("path", null);
        }

        private static String secretPath(String path, String mountPath, boolean metadata) {
            if (mountPath == null) {
                return path;
            }
            StringBuilder joined = new StringBuilder(mountPath);
            joined.append(metadata ? "metadata/" : "data/");
            int index = path.indexOf(mountPath);
            assert (index != -1);
            String subPath = path.substring(index + mountPath.length());
            joined.append(subPath);
            return joined.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Response doGet(String requestUrl) throws Exception {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put(HEADER_TOKEN, this.config.getToken());
            HttpURLConnection connection = null;
            try {
                connection = this.getConnection(requestUrl, this.config.getSSLConfig());
                connection.setRequestMethod("GET");
                connection.setRequestProperty("Connection", "close");
                connection.setConnectTimeout(30000);
                connection.setReadTimeout(30000);
                for (Map.Entry header : headers.entrySet()) {
                    connection.setRequestProperty((String)header.getKey(), (String)header.getValue());
                }
                int statusCode = connection.getResponseCode();
                String contentType = connection.getContentType();
                byte[] body = VaultClient.responseBody(connection);
                Response response = new Response(statusCode, contentType, body);
                return response;
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }

        private HttpURLConnection getConnection(String urlString, SSLConfig sslConfig) throws Exception {
            URL url = URI.create(urlString).toURL();
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            if (connection instanceof HttpsURLConnection) {
                HttpsURLConnection httpsURLConnection = (HttpsURLConnection)connection;
                if (sslConfig == null || !sslConfig.isEnabled()) {
                    throw new SecureStoreException("SSL/TLS not enabled in the configuration");
                }
                SSLContext sslContext = this.loadSSLContextFactory(sslConfig).getSSLContext();
                httpsURLConnection.setSSLSocketFactory(sslContext.getSocketFactory());
            }
            return connection;
        }

        private SSLContextFactory loadSSLContextFactory(SSLConfig config) throws Exception {
            Object implementation = config.getFactoryImplementation();
            String factoryClassName = config.getFactoryClassName();
            if (implementation == null && factoryClassName != null) {
                implementation = ClassLoaderUtil.newInstance(this.classLoader, factoryClassName);
            }
            if (implementation == null) {
                implementation = new BasicSSLContextFactory();
            }
            SSLContextFactory sslContextFactory = (SSLContextFactory)implementation;
            sslContextFactory.init(config.getProperties());
            return sslContextFactory;
        }

        private static byte[] responseBody(HttpURLConnection conn) throws IOException {
            try (InputStream in = VaultClient.getStream(conn);){
                if (in != null) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    in.transferTo(out);
                    byte[] byArray = out.toByteArray();
                    return byArray;
                }
            }
            return EMPTY_BYTE_ARRAY;
        }

        private static InputStream getStream(HttpURLConnection conn) throws IOException {
            int responseCode = conn.getResponseCode();
            InputStream inputStream = responseCode < 400 ? conn.getInputStream() : conn.getErrorStream();
            return inputStream;
        }

        private record Range(int min, int max) {
        }

        private record Response(int statusCode, String contentType, byte[] body) {
            @Override
            public String toString() {
                return "Response{statusCode: " + this.statusCode + ", contentType: " + this.contentType + ", body: " + new String(this.body, StandardCharsets.UTF_8) + "}";
            }
        }
    }

    private final class VaultWatcher
    implements Runnable {
        private byte[] lastKey;

        private VaultWatcher() {
            this.lastKey = VaultSecureStore.this.client.retrieveCurrentEncryptionKey();
        }

        @Override
        public void run() {
            try {
                byte[] currentKey = VaultSecureStore.this.client.retrieveCurrentEncryptionKey();
                if (currentKey != null && !Arrays.equals(currentKey, this.lastKey)) {
                    VaultSecureStore.this.logger.info("Vault encryption key change detected");
                    this.lastKey = currentKey;
                    VaultSecureStore.this.notifyEncryptionKeyListeners(currentKey);
                }
            }
            catch (Exception e) {
                VaultSecureStore.this.logger.warning("Error while detecting changes in Vault", e);
            }
        }
    }
}

