/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.securestore.impl;

import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Disposable;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.executionservice.TaskScheduler;
import com.hazelcast.spi.impl.securestore.SecureStore;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

abstract class AbstractSecureStore
implements SecureStore,
Disposable {
    protected final ILogger logger;
    protected final List<SecureStore.EncryptionKeyListener> listeners = new CopyOnWriteArrayList<SecureStore.EncryptionKeyListener>();
    private final int pollingInterval;
    private final TaskScheduler scheduler;
    private ScheduledFuture<?> watcher;

    AbstractSecureStore(int pollingInterval, @Nonnull Node node) {
        this.pollingInterval = pollingInterval;
        this.scheduler = node.getNodeEngine().getExecutionService().getTaskScheduler(this.getClass().getName());
        this.logger = node.getLogger(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEncryptionKeyListener(@Nonnull SecureStore.EncryptionKeyListener listener) {
        Objects.requireNonNull(listener, "Listener cannot be null!");
        this.listeners.add(listener);
        if (this.pollingInterval != 0) {
            AbstractSecureStore abstractSecureStore = this;
            synchronized (abstractSecureStore) {
                if (this.watcher == null) {
                    this.watcher = this.scheduler.scheduleWithRepetition(this.getWatcher(), 0L, this.pollingInterval, TimeUnit.SECONDS);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        AbstractSecureStore abstractSecureStore = this;
        synchronized (abstractSecureStore) {
            if (this.watcher != null) {
                this.watcher.cancel(true);
                this.watcher = null;
            }
        }
    }

    void notifyEncryptionKeyListeners(@Nonnull byte[] key) {
        for (SecureStore.EncryptionKeyListener listener : this.listeners) {
            listener.onEncryptionKeyChange(key);
        }
    }

    protected abstract Runnable getWatcher();
}

