/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.statistics.distribution;

import com.hazelcast.shaded.org.apache.commons.rng.UniformRandomProvider;
import com.hazelcast.shaded.org.apache.commons.rng.sampling.distribution.ContinuousUniformSampler;
import com.hazelcast.shaded.org.apache.commons.rng.sampling.distribution.SharedStateContinuousSampler;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.AbstractContinuousDistribution;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.ArgumentUtils;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.ContinuousDistribution;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.DistributionException;

public final class UniformContinuousDistribution
extends AbstractContinuousDistribution {
    private final double lower;
    private final double upper;
    private final double upperMinusLower;
    private final double pdf;
    private final double logPdf;

    private UniformContinuousDistribution(double lower, double upper) {
        this.lower = lower;
        this.upper = upper;
        this.upperMinusLower = upper - lower;
        this.pdf = 1.0 / this.upperMinusLower;
        this.logPdf = -Math.log(this.upperMinusLower);
    }

    public static UniformContinuousDistribution of(double lower, double upper) {
        if (lower >= upper) {
            throw new DistributionException("Lower bound %s >= upper bound %s", lower, upper);
        }
        if (!Double.isFinite(upper - lower)) {
            throw new DistributionException("Range %s is not finite", upper - lower);
        }
        return new UniformContinuousDistribution(lower, upper);
    }

    @Override
    public double density(double x) {
        if (x < this.lower || x > this.upper) {
            return 0.0;
        }
        return this.pdf;
    }

    @Override
    public double probability(double x0, double x1) {
        if (x0 > x1) {
            throw new DistributionException("Lower bound %s > upper bound %s", x0, x1);
        }
        if (x0 >= this.upper || x1 <= this.lower) {
            return 0.0;
        }
        double l = Math.max(this.lower, x0);
        double u = Math.min(this.upper, x1);
        return (u - l) / this.upperMinusLower;
    }

    @Override
    public double logDensity(double x) {
        if (x < this.lower || x > this.upper) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.logPdf;
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x <= this.lower) {
            return 0.0;
        }
        if (x >= this.upper) {
            return 1.0;
        }
        return (x - this.lower) / this.upperMinusLower;
    }

    @Override
    public double survivalProbability(double x) {
        if (x <= this.lower) {
            return 1.0;
        }
        if (x >= this.upper) {
            return 0.0;
        }
        return (this.upper - x) / this.upperMinusLower;
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        ArgumentUtils.checkProbability(p);
        return p == 1.0 ? this.upper : p * this.upperMinusLower + this.lower;
    }

    @Override
    public double inverseSurvivalProbability(double p) {
        ArgumentUtils.checkProbability(p);
        return p == 1.0 ? this.lower : this.upper - p * this.upperMinusLower;
    }

    @Override
    public double getMean() {
        return 0.5 * this.lower + 0.5 * this.upper;
    }

    @Override
    public double getVariance() {
        return this.upperMinusLower * this.upperMinusLower / 12.0;
    }

    @Override
    public double getSupportLowerBound() {
        return this.lower;
    }

    @Override
    public double getSupportUpperBound() {
        return this.upper;
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(UniformRandomProvider rng) {
        return () -> ((SharedStateContinuousSampler)ContinuousUniformSampler.of((UniformRandomProvider)rng, (double)this.lower, (double)this.upper)).sample();
    }
}

