/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.statistics.distribution;

import com.hazelcast.shaded.org.apache.commons.numbers.gamma.ErfDifference;
import com.hazelcast.shaded.org.apache.commons.numbers.gamma.Erfc;
import com.hazelcast.shaded.org.apache.commons.numbers.gamma.InverseErfc;
import com.hazelcast.shaded.org.apache.commons.rng.UniformRandomProvider;
import com.hazelcast.shaded.org.apache.commons.rng.sampling.distribution.LogNormalSampler;
import com.hazelcast.shaded.org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;
import com.hazelcast.shaded.org.apache.commons.rng.sampling.distribution.SharedStateContinuousSampler;
import com.hazelcast.shaded.org.apache.commons.rng.sampling.distribution.ZigguratSampler;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.AbstractContinuousDistribution;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.ArgumentUtils;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.ContinuousDistribution;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.DistributionException;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.ExtendedPrecision;

public final class LogNormalDistribution
extends AbstractContinuousDistribution {
    private static final double SQRT2PI = Math.sqrt(Math.PI * 2);
    private final double mu;
    private final double sigma;
    private final double logSigmaPlusHalfLog2Pi;
    private final double sigmaSqrt2;
    private final double sigmaSqrt2Pi;

    private LogNormalDistribution(double mu, double sigma) {
        this.mu = mu;
        this.sigma = sigma;
        this.logSigmaPlusHalfLog2Pi = Math.log(sigma) + 0.9189385332046728;
        this.sigmaSqrt2 = ExtendedPrecision.sqrt2xx(sigma);
        this.sigmaSqrt2Pi = sigma * SQRT2PI;
    }

    public static LogNormalDistribution of(double mu, double sigma) {
        if (sigma <= 0.0) {
            throw new DistributionException("Number %s is not greater than 0", sigma);
        }
        return new LogNormalDistribution(mu, sigma);
    }

    public double getMu() {
        return this.mu;
    }

    public double getSigma() {
        return this.sigma;
    }

    @Override
    public double density(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        double x0 = Math.log(x) - this.mu;
        double x1 = x0 / this.sigma;
        return Math.exp(-0.5 * x1 * x1) / (this.sigmaSqrt2Pi * x);
    }

    @Override
    public double probability(double x0, double x1) {
        if (x0 > x1) {
            throw new DistributionException("Lower bound %s > upper bound %s", x0, x1);
        }
        if (x0 <= 0.0) {
            return this.cumulativeProbability(x1);
        }
        double v0 = (Math.log(x0) - this.mu) / this.sigmaSqrt2;
        double v1 = (Math.log(x1) - this.mu) / this.sigmaSqrt2;
        return 0.5 * ErfDifference.value(v0, v1);
    }

    @Override
    public double logDensity(double x) {
        if (x <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        double logX = Math.log(x);
        double x0 = logX - this.mu;
        double x1 = x0 / this.sigma;
        return -0.5 * x1 * x1 - (this.logSigmaPlusHalfLog2Pi + logX);
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        double dev = Math.log(x) - this.mu;
        return 0.5 * Erfc.value(-dev / this.sigmaSqrt2);
    }

    @Override
    public double survivalProbability(double x) {
        if (x <= 0.0) {
            return 1.0;
        }
        double dev = Math.log(x) - this.mu;
        return 0.5 * Erfc.value(dev / this.sigmaSqrt2);
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        ArgumentUtils.checkProbability(p);
        return Math.exp(this.mu - this.sigmaSqrt2 * InverseErfc.value(2.0 * p));
    }

    @Override
    public double inverseSurvivalProbability(double p) {
        ArgumentUtils.checkProbability(p);
        return Math.exp(this.mu + this.sigmaSqrt2 * InverseErfc.value(2.0 * p));
    }

    @Override
    public double getMean() {
        double s = this.sigma;
        return Math.exp(this.mu + s * s / 2.0);
    }

    @Override
    public double getVariance() {
        double s = this.sigma;
        double ss = s * s;
        return Math.expm1(ss) * Math.exp(2.0 * this.mu + ss);
    }

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(UniformRandomProvider rng) {
        ZigguratSampler.NormalizedGaussian gaussian = ZigguratSampler.NormalizedGaussian.of((UniformRandomProvider)rng);
        return () -> ((SharedStateContinuousSampler)LogNormalSampler.of((NormalizedGaussianSampler)gaussian, (double)this.mu, (double)this.sigma)).sample();
    }
}

