/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.statistics.distribution;

import com.hazelcast.shaded.org.apache.commons.numbers.gamma.LogGamma;
import com.hazelcast.shaded.org.apache.commons.numbers.gamma.RegularizedGamma;
import com.hazelcast.shaded.org.apache.commons.rng.UniformRandomProvider;
import com.hazelcast.shaded.org.apache.commons.rng.sampling.distribution.AhrensDieterMarsagliaTsangGammaSampler;
import com.hazelcast.shaded.org.apache.commons.rng.sampling.distribution.SharedStateContinuousSampler;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.AbstractContinuousDistribution;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.ContinuousDistribution;
import com.hazelcast.shaded.org.apache.commons.statistics.distribution.DistributionException;

public final class GammaDistribution
extends AbstractContinuousDistribution {
    private static final double SUPPORT_LO = 0.0;
    private static final double SUPPORT_HI = Double.POSITIVE_INFINITY;
    private final double shape;
    private final double scale;
    private final double minusLogGammaShapeMinusLogScale;
    private final double mean;
    private final double variance;

    private GammaDistribution(double shape, double scale) {
        this.shape = shape;
        this.scale = scale;
        this.minusLogGammaShapeMinusLogScale = -LogGamma.value(shape) - Math.log(scale);
        this.mean = shape * scale;
        this.variance = shape * scale * scale;
    }

    public static GammaDistribution of(double shape, double scale) {
        if (shape <= 0.0) {
            throw new DistributionException("Number %s is not greater than 0", shape);
        }
        if (scale <= 0.0) {
            throw new DistributionException("Number %s is not greater than 0", scale);
        }
        return new GammaDistribution(shape, scale);
    }

    public double getShape() {
        return this.shape;
    }

    public double getScale() {
        return this.scale;
    }

    @Override
    public double density(double x) {
        if (x <= 0.0 || x >= Double.POSITIVE_INFINITY) {
            if (x == 0.0 && this.shape <= 1.0) {
                return this.shape == 1.0 ? 1.0 / this.scale : Double.POSITIVE_INFINITY;
            }
            return 0.0;
        }
        return RegularizedGamma.P.derivative(this.shape, x / this.scale) / this.scale;
    }

    @Override
    public double logDensity(double x) {
        if (x <= 0.0 || x >= Double.POSITIVE_INFINITY) {
            if (x == 0.0 && this.shape <= 1.0) {
                return this.shape == 1.0 ? -Math.log(this.scale) : Double.POSITIVE_INFINITY;
            }
            return Double.NEGATIVE_INFINITY;
        }
        double y = x / this.scale;
        double p = RegularizedGamma.P.derivative(this.shape, y) / this.scale;
        if (p <= Double.MAX_VALUE && p >= Double.MIN_NORMAL) {
            return Math.log(p);
        }
        return this.minusLogGammaShapeMinusLogScale - y + Math.log(y) * (this.shape - 1.0);
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        if (x >= Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        return RegularizedGamma.P.value(this.shape, x / this.scale);
    }

    @Override
    public double survivalProbability(double x) {
        if (x <= 0.0) {
            return 1.0;
        }
        if (x >= Double.POSITIVE_INFINITY) {
            return 0.0;
        }
        return RegularizedGamma.Q.value(this.shape, x / this.scale);
    }

    @Override
    public double getMean() {
        return this.mean;
    }

    @Override
    public double getVariance() {
        return this.variance;
    }

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(UniformRandomProvider rng) {
        return () -> ((SharedStateContinuousSampler)AhrensDieterMarsagliaTsangGammaSampler.of((UniformRandomProvider)rng, (double)this.shape, (double)this.scale)).sample();
    }
}

