/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.numbers.gamma;

public final class Trigamma {
    private static final double C_LIMIT = 49.0;
    private static final double S_LIMIT = 1.0E-5;
    private static final double F_1_6 = 0.16666666666666666;
    private static final double F_1_30 = 0.03333333333333333;
    private static final double F_1_42 = 0.023809523809523808;

    private Trigamma() {
    }

    public static double value(double x) {
        if (!Double.isFinite(x)) {
            return x;
        }
        if (x > 0.0 && x <= 1.0E-5) {
            return 1.0 / (x * x);
        }
        double trigamma = 0.0;
        while (x < 49.0) {
            trigamma += 1.0 / (x * x);
            x += 1.0;
        }
        double inv = 1.0 / (x * x);
        return trigamma += 1.0 / x + inv / 2.0 + inv / x * (0.16666666666666666 - inv * (0.03333333333333333 + 0.023809523809523808 * inv));
    }
}

