/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.numbers.gamma;

import com.hazelcast.shaded.org.apache.commons.numbers.gamma.Gamma;
import com.hazelcast.shaded.org.apache.commons.numbers.gamma.GammaException;
import com.hazelcast.shaded.org.apache.commons.numbers.gamma.LogGamma;
import com.hazelcast.shaded.org.apache.commons.numbers.gamma.LogGammaSum;

public final class LogBeta {
    private static final double TEN = 10.0;
    private static final double TWO = 2.0;
    private static final double THOUSAND = 1000.0;
    private static final double HALF_LOG_TWO_PI = 0.9189385332046727;
    private static final double[] DELTA = new double[]{0.08333333333333333, -2.777777777777778E-5, 7.936507936507937E-8, -5.952380952380953E-10, 8.417508417508329E-12, -1.917526917518546E-13, 6.410256405103255E-15, -2.955065141253382E-16, 1.7964371635940225E-17, -1.3922896466162779E-18, 1.338028550140209E-19, -1.542460098679661E-20, 1.9770199298095743E-21, -2.3406566479399704E-22, 1.713480149663986E-23};

    private LogBeta() {
    }

    private static double deltaMinusDeltaSum(double a2, double b) {
        double h = a2 / b;
        double p = h / (1.0 + h);
        double q = 1.0 / (1.0 + h);
        double q2 = q * q;
        double[] s = new double[DELTA.length];
        s[0] = 1.0;
        for (int i = 1; i < s.length; ++i) {
            s[i] = 1.0 + (q + q2 * s[i - 1]);
        }
        double sqrtT = 10.0 / b;
        double t = sqrtT * sqrtT;
        double w = DELTA[DELTA.length - 1] * s[s.length - 1];
        for (int i = DELTA.length - 2; i >= 0; --i) {
            w = t * w + DELTA[i] * s[i];
        }
        return w * p / b;
    }

    private static double sumDeltaMinusDeltaSum(double p, double q) {
        if (p < 10.0) {
            throw new GammaException("Number %s is out of range [%s, %s]", p, 10.0, Double.POSITIVE_INFINITY);
        }
        if (q < 10.0) {
            throw new GammaException("Number %s is out of range [%s, %s]", q, 10.0, Double.POSITIVE_INFINITY);
        }
        double a2 = Math.min(p, q);
        double b = Math.max(p, q);
        double sqrtT = 10.0 / a2;
        double t = sqrtT * sqrtT;
        double z = DELTA[DELTA.length - 1];
        for (int i = DELTA.length - 2; i >= 0; --i) {
            z = t * z + DELTA[i];
        }
        return z / a2 + LogBeta.deltaMinusDeltaSum(a2, b);
    }

    public static double value(double p, double q) {
        if (Double.isNaN(p) || Double.isNaN(q) || p <= 0.0 || q <= 0.0) {
            return Double.NaN;
        }
        double a2 = Math.min(p, q);
        double b = Math.max(p, q);
        if (a2 >= 10.0) {
            double v;
            double w = LogBeta.sumDeltaMinusDeltaSum(a2, b);
            double h = a2 / b;
            double c = h / (1.0 + h);
            double u = -(a2 - 0.5) * Math.log(c);
            if (u <= (v = b * Math.log1p(h))) {
                return -0.5 * Math.log(b) + 0.9189385332046727 + w - u - v;
            }
            return -0.5 * Math.log(b) + 0.9189385332046727 + w - v - u;
        }
        if (a2 > 2.0) {
            if (b > 1000.0) {
                int n = (int)Math.floor(a2 - 1.0);
                double prod = 1.0;
                double ared = a2;
                for (int i = 0; i < n; ++i) {
                    prod *= (ared -= 1.0) / (1.0 + ared / b);
                }
                return Math.log(prod) - (double)n * Math.log(b) + (LogGamma.value(ared) + LogBeta.logGammaMinusLogGammaSum(ared, b));
            }
            double prod1 = 1.0;
            double ared = a2;
            while (ared > 2.0) {
                double h = (ared -= 1.0) / b;
                prod1 *= h / (1.0 + h);
            }
            if (b < 10.0) {
                double prod2 = 1.0;
                double bred = b;
                while (bred > 2.0) {
                    prod2 *= (bred -= 1.0) / (ared + bred);
                }
                return Math.log(prod1) + Math.log(prod2) + (LogGamma.value(ared) + (LogGamma.value(bred) - LogGammaSum.value(ared, bred)));
            }
            return Math.log(prod1) + LogGamma.value(ared) + LogBeta.logGammaMinusLogGammaSum(ared, b);
        }
        if (a2 >= 1.0) {
            if (b > 2.0) {
                if (b < 10.0) {
                    double prod = 1.0;
                    double bred = b;
                    while (bred > 2.0) {
                        prod *= (bred -= 1.0) / (a2 + bred);
                    }
                    return Math.log(prod) + (LogGamma.value(a2) + (LogGamma.value(bred) - LogGammaSum.value(a2, bred)));
                }
                return LogGamma.value(a2) + LogBeta.logGammaMinusLogGammaSum(a2, b);
            }
            return LogGamma.value(a2) + LogGamma.value(b) - LogGammaSum.value(a2, b);
        }
        if (b >= 10.0) {
            return LogGamma.value(a2) + LogBeta.logGammaMinusLogGammaSum(a2, b);
        }
        double beta = Gamma.value(a2) * Gamma.value(b) / Gamma.value(a2 + b);
        if (Double.isFinite(beta)) {
            return Math.log(beta);
        }
        return LogGamma.value(a2) + (LogGamma.value(b) - LogGamma.value(a2 + b));
    }

    private static double logGammaMinusLogGammaSum(double a2, double b) {
        double v;
        if (a2 < 0.0) {
            throw new GammaException("Number %s is out of range [%s, %s]", a2, 0, Double.POSITIVE_INFINITY);
        }
        if (b < 10.0) {
            throw new GammaException("Number %s is out of range [%s, %s]", b, 10.0, Double.POSITIVE_INFINITY);
        }
        double d = b + (a2 - 0.5);
        double w = LogBeta.deltaMinusDeltaSum(a2, b);
        double u = d * Math.log1p(a2 / b);
        return u <= (v = a2 * (Math.log(b) - 1.0)) ? w - u - v : w - v - u;
    }
}

