/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.numbers.gamma;

import java.util.function.DoubleSupplier;

final class BoostTools {
    private static final double EPSILON = 2.220446049250313E-16;
    private static final double KAHAN_EPSILON = 2.168404344971009E-19;
    private static final String MSG_FAILED_TO_CONVERGE = "Failed to converge within %d iterations";

    private BoostTools() {
    }

    static double sumSeries(DoubleSupplier func, double epsilon, int maxTerms) {
        return BoostTools.sumSeries(func, epsilon, maxTerms, 0.0);
    }

    static double sumSeries(DoubleSupplier func, double epsilon, int maxTerms, double initValue) {
        double nextTerm;
        double eps = BoostTools.getEpsilon(epsilon, 2.220446049250313E-16);
        int counter = maxTerms;
        double result = initValue;
        while (Math.abs(eps * (result += (nextTerm = func.getAsDouble()))) < Math.abs(nextTerm) && --counter > 0) {
        }
        if (counter <= 0) {
            throw new ArithmeticException(String.format(MSG_FAILED_TO_CONVERGE, maxTerms));
        }
        return result;
    }

    static double kahanSumSeries(DoubleSupplier func, double epsilon, int maxTerms) {
        return BoostTools.kahanSumSeries(func, epsilon, maxTerms, 0.0);
    }

    static double kahanSumSeries(DoubleSupplier func, double epsilon, int maxTerms, double initValue) {
        double nextTerm;
        double t;
        double eps = BoostTools.getEpsilon(epsilon, 2.168404344971009E-19);
        int counter = maxTerms;
        double result = initValue;
        double carry = 0.0;
        do {
            nextTerm = func.getAsDouble();
            double y = nextTerm - carry;
            t = result + y;
            carry = t - result;
            carry -= y;
        } while (Math.abs(eps * (result = t)) < Math.abs(nextTerm) && --counter > 0);
        if (counter <= 0) {
            throw new ArithmeticException(String.format(MSG_FAILED_TO_CONVERGE, maxTerms));
        }
        return result;
    }

    private static double getEpsilon(double epsilon, double minEpsilon) {
        return epsilon > minEpsilon ? epsilon : minEpsilon;
    }

    static double evaluatePolynomial(double[] c, double x) {
        int count = c.length;
        double sum = c[count - 1];
        for (int i = count - 2; i >= 0; --i) {
            sum *= x;
            sum += c[i];
        }
        return sum;
    }
}

