/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.agrona.nio;

import com.hazelcast.shaded.org.agrona.LangUtil;
import com.hazelcast.shaded.org.agrona.nio.NioSelectedKeySet;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.channels.Selector;

public class TransportPoller
implements AutoCloseable {
    public static final String ITERATION_THRESHOLD_PROP_NAME = "com.hazelcast.shaded.org.agrona.transport.iteration.threshold";
    public static final int ITERATION_THRESHOLD_DEFAULT = 5;
    public static final int ITERATION_THRESHOLD = Integer.getInteger("com.hazelcast.shaded.org.agrona.transport.iteration.threshold", 5);
    protected static final Field SELECTED_KEYS_FIELD;
    protected static final Field PUBLIC_SELECTED_KEYS_FIELD;
    private static final String SELECTOR_IMPL = "sun.nio.ch.SelectorImpl";
    protected final NioSelectedKeySet selectedKeySet = new NioSelectedKeySet();
    protected final Selector selector;

    public TransportPoller() {
        try {
            this.selector = Selector.open();
            SELECTED_KEYS_FIELD.set(this.selector, this.selectedKeySet);
            PUBLIC_SELECTED_KEYS_FIELD.set(this.selector, this.selectedKeySet);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void close() {
        this.selector.wakeup();
        try {
            this.selector.close();
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
    }

    public void selectNowWithoutProcessing() {
        try {
            this.selector.selectNow();
            this.selectedKeySet.clear();
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Field selectKeysField = null;
        Field publicSelectKeysField = null;
        try (Selector selector = Selector.open();){
            Class<?> clazz = Class.forName(SELECTOR_IMPL, false, ClassLoader.getSystemClassLoader());
            if (clazz.isAssignableFrom(selector.getClass())) {
                selectKeysField = clazz.getDeclaredField("selectedKeys");
                selectKeysField.setAccessible(true);
                publicSelectKeysField = clazz.getDeclaredField("publicSelectedKeys");
                publicSelectKeysField.setAccessible(true);
            }
        }
        catch (Exception ex) {
            LangUtil.rethrowUnchecked(ex);
        }
        finally {
            SELECTED_KEYS_FIELD = selectKeysField;
            PUBLIC_SELECTED_KEYS_FIELD = publicSelectKeysField;
        }
    }
}

