/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.agrona.concurrent;

import com.hazelcast.shaded.org.agrona.concurrent.IdleStrategy;

public final class SleepingMillisIdleStrategy
implements IdleStrategy {
    public static final String ALIAS = "sleep-ms";
    public static final long DEFAULT_SLEEP_PERIOD_MS = 1L;
    private final long sleepPeriodMs;

    public SleepingMillisIdleStrategy() {
        this.sleepPeriodMs = 1L;
    }

    public SleepingMillisIdleStrategy(long sleepPeriodMs) {
        this.sleepPeriodMs = sleepPeriodMs;
    }

    @Override
    public void idle(int workCount) {
        if (workCount > 0) {
            return;
        }
        try {
            Thread.sleep(this.sleepPeriodMs);
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void idle() {
        try {
            Thread.sleep(this.sleepPeriodMs);
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public String alias() {
        return ALIAS;
    }

    public String toString() {
        return "SleepingMillisIdleStrategy{alias=sleep-ms, sleepPeriodMs=" + this.sleepPeriodMs + '}';
    }
}

