/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.agrona.collections;

import java.util.function.Consumer;
import java.util.function.IntFunction;

public final class IntLruCache<E>
implements AutoCloseable {
    private final int capacity;
    private final IntFunction<E> factory;
    private final Consumer<E> closer;
    private final int[] keys;
    private final Object[] values;
    private int size;

    public IntLruCache(int capacity, IntFunction<E> factory, Consumer<E> closer) {
        this.capacity = capacity;
        this.factory = factory;
        this.closer = closer;
        this.keys = new int[capacity];
        this.values = new Object[capacity];
        this.size = 0;
    }

    public E lookup(int key) {
        int size = this.size;
        int[] keys = this.keys;
        Object[] values = this.values;
        for (int i = 0; i < size; ++i) {
            if (key != keys[i]) continue;
            Object value = values[i];
            this.makeMostRecent(key, value, i);
            return (E)value;
        }
        E value = this.factory.apply(key);
        if (value != null) {
            if (this.capacity == size) {
                this.closer.accept(values[size - 1]);
            } else {
                this.size = ++size;
            }
            this.makeMostRecent(key, value, size - 1);
        }
        return value;
    }

    private void makeMostRecent(int key, Object value, int fromIndex) {
        int[] keys = this.keys;
        Object[] values = this.values;
        for (int i = fromIndex; i > 0; --i) {
            keys[i] = keys[i - 1];
            values[i] = values[i - 1];
        }
        keys[0] = key;
        values[0] = value;
    }

    public int capacity() {
        return this.capacity;
    }

    @Override
    public void close() {
        Consumer<E> closer = this.closer;
        Object[] values = this.values;
        int size = this.size;
        for (int i = 0; i < size; ++i) {
            closer.accept(values[i]);
        }
    }
}

