/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.io.github.jbellis.jvector.vector;

import com.hazelcast.shaded.io.github.jbellis.jvector.util.RamUsageEstimator;
import com.hazelcast.shaded.io.github.jbellis.jvector.vector.ArrayByteSequence;
import com.hazelcast.shaded.io.github.jbellis.jvector.vector.types.ByteSequence;
import java.util.Arrays;

public class ArraySliceByteSequence
implements ByteSequence<byte[]> {
    private final ByteSequence<byte[]> data;
    private final int offset;
    private final int length;

    public ArraySliceByteSequence(ByteSequence<byte[]> data, int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > data.length()) {
            throw new IllegalArgumentException("Invalid offset or length");
        }
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public byte[] get() {
        return this.data.get();
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    public byte get(int n) {
        return this.data.get(this.offset + n);
    }

    @Override
    public void set(int n, byte value) {
        this.data.set(this.offset + n, value);
    }

    @Override
    public void setLittleEndianShort(int shortIndex, short value) {
        this.data.set(this.offset + shortIndex * 2, (byte)(value & 0xFF));
        this.data.set(this.offset + shortIndex * 2 + 1, (byte)(value >> 8 & 0xFF));
    }

    @Override
    public void zero() {
        for (int i = 0; i < this.length; ++i) {
            this.data.set(this.offset + i, (byte)0);
        }
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public ByteSequence<byte[]> copy() {
        byte[] newData = Arrays.copyOfRange(this.data.get(), this.offset, this.offset + this.length);
        return new ArrayByteSequence(newData);
    }

    @Override
    public ByteSequence<byte[]> slice(int sliceOffset, int sliceLength) {
        if (sliceOffset < 0 || sliceLength < 0 || sliceOffset + sliceLength > this.length) {
            throw new IllegalArgumentException("Invalid slice parameters");
        }
        if (sliceOffset == 0 && sliceLength == this.length) {
            return this;
        }
        return new ArraySliceByteSequence(this.data, this.offset + sliceOffset, sliceLength);
    }

    @Override
    public long ramBytesUsed() {
        return (long)RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + this.data.ramBytesUsed() + 8L;
    }

    @Override
    public void copyFrom(ByteSequence<?> src, int srcOffset, int destOffset, int copyLength) {
        if (src instanceof ArraySliceByteSequence) {
            ArraySliceByteSequence srcSlice = (ArraySliceByteSequence)src;
            this.data.copyFrom(srcSlice.data, srcSlice.offset + srcOffset, this.offset + destOffset, copyLength);
        } else {
            for (int i = 0; i < copyLength; ++i) {
                this.data.set(this.offset + destOffset + i, src.get(srcOffset + i));
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < Math.min(this.length, 25); ++i) {
            sb.append(this.get(i));
            if (i >= this.length - 1) continue;
            sb.append(", ");
        }
        if (this.length > 25) {
            sb.append("...");
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        return this.equalTo(o);
    }

    public int hashCode() {
        return this.getHashCode();
    }
}

