/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.io.github.jbellis.jvector.util;

import java.io.Closeable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.function.Supplier;

public class PhysicalCoreExecutor
implements Closeable {
    private static final int physicalCoreCount = Integer.getInteger("jvector.physical_core_count", Math.max(1, Runtime.getRuntime().availableProcessors() / 2));
    public static final PhysicalCoreExecutor instance = new PhysicalCoreExecutor(physicalCoreCount);
    private final ForkJoinPool pool;

    public static ForkJoinPool pool() {
        return PhysicalCoreExecutor.instance.pool;
    }

    private PhysicalCoreExecutor(int cores) {
        assert (cores > 0 && cores <= Runtime.getRuntime().availableProcessors()) : "Invalid core count: " + cores;
        this.pool = new ForkJoinPool(cores);
    }

    public void execute(Runnable run) {
        ((ForkJoinTask)this.pool.submit(run)).join();
    }

    public <T> T submit(Supplier<T> run) {
        return (T)((ForkJoinTask)this.pool.submit(run::get)).join();
    }

    public static int getPhysicalCoreCount() {
        return physicalCoreCount;
    }

    @Override
    public void close() {
        this.pool.shutdownNow();
    }
}

