/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.io.github.jbellis.jvector.graph;

import com.hazelcast.shaded.io.github.jbellis.jvector.graph.ConcurrentNeighborMap;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.GraphIndex;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.NodeArray;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.NodesIterator;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.similarity.BuildScoreProvider;
import com.hazelcast.shaded.io.github.jbellis.jvector.util.Bits;
import com.hazelcast.shaded.io.github.jbellis.jvector.util.RamUsageEstimator;
import com.hazelcast.shaded.io.github.jbellis.jvector.util.ThreadSafeGrowableBitSet;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;

public class OnHeapGraphIndex
implements GraphIndex {
    static final int NO_ENTRY_POINT = -1;
    private final AtomicInteger entryPoint = new AtomicInteger(-1);
    final ConcurrentNeighborMap nodes;
    private final ThreadSafeGrowableBitSet deletedNodes = new ThreadSafeGrowableBitSet(0);
    private final AtomicInteger maxNodeId = new AtomicInteger(-1);
    final int maxDegree;

    OnHeapGraphIndex(int M, int maxOverflowDegree, BuildScoreProvider scoreProvider, float alpha) {
        this.maxDegree = M;
        this.nodes = new ConcurrentNeighborMap(scoreProvider, this.maxDegree, maxOverflowDegree, alpha);
    }

    ConcurrentNeighborMap.Neighbors getNeighbors(int node) {
        return this.nodes.get(node);
    }

    @Override
    public int size() {
        return this.nodes.size();
    }

    public void addNode(int nodeId) {
        this.nodes.addNode(nodeId);
        this.maxNodeId.accumulateAndGet(nodeId, Math::max);
    }

    void addNode(int nodeId, NodeArray nodes) {
        assert (nodes != null);
        this.nodes.addNode(nodeId, nodes);
        this.maxNodeId.accumulateAndGet(nodeId, Math::max);
    }

    public void markDeleted(int node) {
        this.deletedNodes.set(node);
    }

    void maybeSetInitialEntryNode(int node) {
        this.entryPoint.accumulateAndGet(node, (oldEntry, newEntry) -> {
            if (oldEntry >= 0) {
                return oldEntry;
            }
            return newEntry;
        });
    }

    void updateEntryNode(int node) {
        this.entryPoint.set(node);
    }

    @Override
    public int maxDegree() {
        return this.maxDegree;
    }

    int entry() {
        return this.entryPoint.get();
    }

    @Override
    public NodesIterator getNodes() {
        return this.nodes.nodesIterator();
    }

    @Override
    public long ramBytesUsed() {
        int OH_BYTES = RamUsageEstimator.NUM_BYTES_OBJECT_HEADER;
        int REF_BYTES = RamUsageEstimator.NUM_BYTES_OBJECT_REF;
        int AH_BYTES = RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;
        long neighborSize = this.ramBytesUsedOneNode() * (long)this.size();
        return (long)OH_BYTES + (long)REF_BYTES * 2L + (long)AH_BYTES + neighborSize;
    }

    public long ramBytesUsedOneNode() {
        int REF_BYTES = RamUsageEstimator.NUM_BYTES_OBJECT_REF;
        return (long)REF_BYTES + ConcurrentNeighborMap.Neighbors.ramBytesUsed(this.nodes.nodeArrayLength());
    }

    public String toString() {
        return String.format("OnHeapGraphIndex(size=%d, entryPoint=%d)", this.size(), this.entryPoint.get());
    }

    @Override
    public void close() {
    }

    @Override
    public ConcurrentGraphIndexView getView() {
        return new ConcurrentGraphIndexView();
    }

    void validateEntryNode() {
        if (this.size() == 0) {
            return;
        }
        int en = this.entryPoint.get();
        if (en < 0 || this.getNeighbors(en) == null) {
            throw new IllegalStateException("Entry node was incompletely added! " + en);
        }
    }

    public ThreadSafeGrowableBitSet getDeletedNodes() {
        return this.deletedNodes;
    }

    boolean removeNode(int node) {
        try {
            boolean bl = this.nodes.remove(node) != null;
            return bl;
        }
        finally {
            this.deletedNodes.clear(node);
        }
    }

    @Override
    public int getIdUpperBound() {
        return this.maxNodeId.get() + 1;
    }

    @Override
    public boolean containsNode(int nodeId) {
        return this.nodes.contains(nodeId);
    }

    public double getAverageDegree() {
        return IntStream.range(0, this.getIdUpperBound()).filter(this::containsNode).mapToDouble(i -> this.getNeighbors(i).size()).average().orElse(Double.NaN);
    }

    public void save(DataOutput out) {
        if (this.deletedNodes.cardinality() > 0) {
            throw new IllegalStateException("Cannot save a graph that has deleted nodes.  Call cleanup() first");
        }
        try (ConcurrentGraphIndexView view = this.getView();){
            out.writeInt(this.size());
            out.writeInt(view.entryNode());
            out.writeInt(this.maxDegree());
            this.nodes.forEach((nodeId, value) -> {
                try {
                    NodesIterator neighbors = value.iterator();
                    out.writeInt(nodeId);
                    out.writeInt(neighbors.size());
                    for (int n = 0; n < neighbors.size(); ++n) {
                        out.writeInt(neighbors.nextInt());
                    }
                    assert (!neighbors.hasNext());
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public class ConcurrentGraphIndexView
    implements GraphIndex.View {
        @Override
        public NodesIterator getNeighborsIterator(int node) {
            ConcurrentNeighborMap.Neighbors neighbors = OnHeapGraphIndex.this.getNeighbors(node);
            assert (neighbors != null) : "Node " + node + " not found";
            return neighbors.iterator();
        }

        @Override
        public int size() {
            return OnHeapGraphIndex.this.size();
        }

        @Override
        public int entryNode() {
            return OnHeapGraphIndex.this.entryPoint.get();
        }

        public String toString() {
            return "OnHeapGraphIndexView(size=" + this.size() + ", entryPoint=" + OnHeapGraphIndex.this.entryPoint.get();
        }

        @Override
        public Bits liveNodes() {
            return OnHeapGraphIndex.this.deletedNodes.cardinality() == 0 ? Bits.ALL : Bits.inverseOf(OnHeapGraphIndex.this.deletedNodes);
        }

        @Override
        public int getIdUpperBound() {
            return OnHeapGraphIndex.this.getIdUpperBound();
        }

        @Override
        public void close() {
        }
    }
}

