/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.io.github.jbellis.jvector.graph;

import com.hazelcast.shaded.io.github.jbellis.jvector.graph.ConcurrentNeighborMap;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.GraphIndex;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.NodesIterator;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.OnHeapGraphIndex;
import com.hazelcast.shaded.io.github.jbellis.jvector.util.Bits;
import java.io.IOException;
import java.util.NoSuchElementException;

public class HazelcastGraphIndexViewProvider
implements GraphIndex {
    private final HazelcastGraphIndexView indexView;

    public HazelcastGraphIndexViewProvider(OnHeapGraphIndex graphIndex) {
        this.indexView = new HazelcastGraphIndexView(graphIndex);
    }

    @Override
    public GraphIndex.View getView() {
        return this.indexView;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("View holder does not support this operation.");
    }

    @Override
    public NodesIterator getNodes() {
        throw new UnsupportedOperationException("View holder does not support this operation.");
    }

    @Override
    public int maxDegree() {
        throw new UnsupportedOperationException("View holder does not support this operation.");
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException("View holder does not support this operation.");
    }

    @Override
    public long ramBytesUsed() {
        throw new UnsupportedOperationException("View holder does not support this operation.");
    }

    public static class HazelcastGraphIndexView
    implements GraphIndex.View {
        private static final NodesIterator EMPTY_ITERATOR = new NodesIterator(0){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public int nextInt() {
                throw new NoSuchElementException();
            }
        };
        private final OnHeapGraphIndex index;

        private HazelcastGraphIndexView(OnHeapGraphIndex index) {
            this.index = index;
        }

        @Override
        public NodesIterator getNeighborsIterator(int node) {
            ConcurrentNeighborMap.Neighbors neighbors = this.index.getNeighbors(node);
            if (neighbors == null) {
                return EMPTY_ITERATOR;
            }
            return neighbors.iterator();
        }

        @Override
        public int size() {
            return this.index.size();
        }

        @Override
        public int entryNode() {
            return this.index.entry();
        }

        public String toString() {
            return "HazelcastGraphIndexView(size=" + this.size() + ", entryPoint=" + this.index.entry();
        }

        @Override
        public Bits liveNodes() {
            return this.index.getDeletedNodes().cardinality() == 0 ? Bits.ALL : Bits.inverseOf(this.index.getDeletedNodes());
        }

        @Override
        public int getIdUpperBound() {
            return this.index.getIdUpperBound();
        }

        @Override
        public void close() {
        }
    }
}

