/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.io.github.jbellis.jvector.graph;

import com.hazelcast.shaded.io.github.jbellis.jvector.annotations.VisibleForTesting;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.NodeArray;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.NodesIterator;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.similarity.BuildScoreProvider;
import com.hazelcast.shaded.io.github.jbellis.jvector.graph.similarity.ScoreFunction;
import com.hazelcast.shaded.io.github.jbellis.jvector.util.BitSet;
import com.hazelcast.shaded.io.github.jbellis.jvector.util.Bits;
import com.hazelcast.shaded.io.github.jbellis.jvector.util.DenseIntMap;
import com.hazelcast.shaded.io.github.jbellis.jvector.util.FixedBitSet;

public class ConcurrentNeighborMap {
    private final DenseIntMap<Neighbors> neighbors;
    private final float alpha;
    private final BuildScoreProvider scoreProvider;
    public final int maxDegree;
    public final int maxOverflowDegree;

    public ConcurrentNeighborMap(BuildScoreProvider scoreProvider, int maxDegree, int maxOverflowDegree, float alpha) {
        this.alpha = alpha;
        this.scoreProvider = scoreProvider;
        this.maxDegree = maxDegree;
        this.maxOverflowDegree = maxOverflowDegree;
        this.neighbors = new DenseIntMap(1024);
    }

    public void insertEdge(int fromId, int toId, float score, float overflow) {
        Neighbors old;
        Neighbors next;
        while ((next = (old = this.neighbors.get(fromId)).insert(toId, score, overflow, this)) != old && !this.neighbors.compareAndPut(fromId, old, next)) {
        }
    }

    public void insertEdgeNotDiverse(int fromId, int toId, float score) {
        Neighbors old;
        Neighbors next;
        while ((next = (old = this.neighbors.get(fromId)).insertNotDiverse(toId, score, this)) != old && !this.neighbors.compareAndPut(fromId, old, next)) {
        }
    }

    public double enforceDegree(int nodeId) {
        NeighborWithShortEdges nwse;
        Neighbors old = this.neighbors.get(nodeId);
        if (old == null) {
            return Double.NaN;
        }
        do {
            old = this.neighbors.get(nodeId);
            nwse = old.enforceDegree(this);
        } while (nwse.neighbors != old && !this.neighbors.compareAndPut(nodeId, old, nwse.neighbors));
        return nwse.shortEdges;
    }

    public void replaceDeletedNeighbors(int nodeId, BitSet toDelete, NodeArray candidates) {
        Neighbors old;
        Neighbors next;
        while ((next = (old = this.neighbors.get(nodeId)).replaceDeletedNeighbors(toDelete, candidates, this)) != old && !this.neighbors.compareAndPut(nodeId, old, next)) {
        }
    }

    public Neighbors insertDiverse(int nodeId, NodeArray candidates) {
        Neighbors old;
        Neighbors next;
        while ((next = (old = this.neighbors.get(nodeId)).insertDiverse(candidates, this)) != old && !this.neighbors.compareAndPut(nodeId, old, next)) {
        }
        return next;
    }

    public Neighbors get(int node) {
        return this.neighbors.get(node);
    }

    public int size() {
        return this.neighbors.size();
    }

    void addNode(int nodeId, NodeArray nodes) {
        Neighbors next = new Neighbors(nodeId, nodes);
        if (!this.neighbors.compareAndPut(nodeId, null, next)) {
            throw new IllegalStateException("Node " + nodeId + " already exists");
        }
    }

    public void addNode(int nodeId) {
        this.addNode(nodeId, new NodeArray(0));
    }

    public NodesIterator nodesIterator() {
        return this.neighbors.keysIterator();
    }

    public Neighbors remove(int node) {
        return this.neighbors.remove(node);
    }

    public boolean contains(int nodeId) {
        return this.neighbors.containsKey(nodeId);
    }

    public void forEach(DenseIntMap.IntBiConsumer<Neighbors> consumer) {
        this.neighbors.forEach(consumer);
    }

    int nodeArrayLength() {
        return this.maxOverflowDegree + 1;
    }

    public void backlink(NodeArray nodes, int toId, float overflow) {
        for (int i = 0; i < nodes.size(); ++i) {
            int nbr = nodes.getNode(i);
            float nbrScore = nodes.getScore(i);
            this.insertEdge(nbr, toId, nbrScore, overflow);
        }
    }

    public static class Neighbors
    extends NodeArray {
        private final int nodeId;
        private int diverseBefore;

        private Neighbors(int nodeId, NodeArray nodeArray) {
            super(nodeArray);
            this.nodeId = nodeId;
            this.diverseBefore = this.size();
        }

        public NodesIterator iterator() {
            return new NeighborIterator(this);
        }

        @Override
        public Neighbors copy() {
            return this.copy(this.size());
        }

        @Override
        public Neighbors copy(int newSize) {
            NodeArray superCopy = new NodeArray(this).copy(newSize);
            return new Neighbors(this.nodeId, superCopy);
        }

        private NeighborWithShortEdges enforceDegree(ConcurrentNeighborMap map) {
            if (this.size() <= map.maxDegree) {
                return new NeighborWithShortEdges(this, Double.NaN);
            }
            Neighbors next = this.copy();
            double shortEdges = this.retainDiverse(next, this.diverseBefore, map);
            next.diverseBefore = next.size();
            return new NeighborWithShortEdges(next, shortEdges);
        }

        private Neighbors replaceDeletedNeighbors(Bits deletedNodes, NodeArray candidates, ConcurrentNeighborMap map) {
            NodeArray liveNeighbors = new NodeArray(this.size());
            for (int i = 0; i < this.size(); ++i) {
                int nodeId = this.getNode(i);
                if (deletedNodes.get(nodeId)) continue;
                liveNeighbors.addInOrder(nodeId, this.getScore(i));
            }
            NodeArray merged = NodeArray.merge(liveNeighbors, candidates);
            this.retainDiverse(merged, 0, map);
            return new Neighbors(this.nodeId, merged);
        }

        private Neighbors insertDiverse(NodeArray toMerge, ConcurrentNeighborMap map) {
            NodeArray merged;
            if (toMerge.size() == 0) {
                return this;
            }
            if (this.size() > 0) {
                merged = NodeArray.merge(this, toMerge);
                this.retainDiverse(merged, 0, map);
            } else {
                merged = toMerge.copy();
                this.retainDiverse(merged, 0, map);
            }
            NodeArray nextNodes = merged.getArrayLength() <= map.nodeArrayLength() ? merged : merged.copy(map.nodeArrayLength());
            return new Neighbors(this.nodeId, nextNodes);
        }

        private Neighbors insertNotDiverse(int node, float score, ConcurrentNeighborMap map) {
            int maxDegree = map.maxDegree;
            assert (this.size() <= maxDegree) : "insertNotDiverse called before enforcing degree/diversity";
            Neighbors next = this.copy(maxDegree);
            int insertedAt = next.insertOrReplaceWorst(node, score);
            if (insertedAt == -1) {
                return this;
            }
            next.diverseBefore = Math.min(insertedAt, this.diverseBefore);
            return next;
        }

        private double retainDiverse(NodeArray neighbors, int diverseBefore, ConcurrentNeighborMap map) {
            FixedBitSet selected = new FixedBitSet(neighbors.size());
            for (int i = 0; i < Math.min(diverseBefore, map.maxDegree); ++i) {
                ((BitSet)selected).set(i);
            }
            double shortEdges = this.retainDiverseInternal(neighbors, diverseBefore, selected, map);
            neighbors.retain(selected);
            return shortEdges;
        }

        private double retainDiverseInternal(NodeArray neighbors, int diverseBefore, BitSet selected, ConcurrentNeighborMap map) {
            int nSelected = diverseBefore;
            double shortEdges = Double.NaN;
            float a2 = 1.0f;
            while ((double)a2 <= (double)map.alpha + 1.0E-6 && nSelected < map.maxDegree) {
                for (int i = diverseBefore; i < neighbors.size() && nSelected < map.maxDegree; ++i) {
                    ScoreFunction sf;
                    float cScore;
                    int cNode;
                    if (selected.get(i) || !this.isDiverse(cNode = neighbors.getNode(i), cScore = neighbors.getScore(i), neighbors, sf = map.scoreProvider.diversityProviderFor(cNode).scoreFunction(), selected, a2)) continue;
                    selected.set(i);
                    ++nSelected;
                }
                if (a2 == 1.0f) {
                    shortEdges = (float)nSelected / (float)map.maxDegree;
                }
                a2 += 0.2f;
            }
            return shortEdges;
        }

        private boolean isDiverse(int node, float score, NodeArray others, ScoreFunction sf, BitSet selected, float alpha) {
            int otherNode;
            assert (others.size() > 0);
            int i = selected.nextSetBit(0);
            while (i != Integer.MAX_VALUE && node != (otherNode = others.getNode(i))) {
                if (sf.similarityTo(otherNode) > score * alpha) {
                    return false;
                }
                i = selected.nextSetBit(i + 1);
            }
            return true;
        }

        private Neighbors insert(int neighborId, float score, float overflow, ConcurrentNeighborMap map) {
            assert (neighborId != this.nodeId) : "can't add self as neighbor at node " + this.nodeId;
            int hardMax = (int)(overflow * (float)map.maxDegree);
            assert (hardMax <= map.maxOverflowDegree) : String.format("overflow %s could exceed max overflow degree %d", Float.valueOf(overflow), map.maxOverflowDegree);
            Neighbors next = this.copy(map.nodeArrayLength());
            int insertionPoint = next.insertSorted(neighborId, score);
            if (insertionPoint == -1) {
                return this;
            }
            next.diverseBefore = Math.min(insertionPoint, this.diverseBefore);
            if (next.size() > hardMax) {
                this.retainDiverse(next, next.diverseBefore, map);
                next.diverseBefore = next.size();
            }
            return next;
        }

        public static long ramBytesUsed(int count) {
            return NodeArray.ramBytesUsed(count) + 4L + 4L;
        }

        @Override
        @VisibleForTesting
        boolean contains(int i) {
            NodesIterator it = this.iterator();
            while (it.hasNext()) {
                if (it.nextInt() != i) continue;
                return true;
            }
            return false;
        }
    }

    private static class NeighborWithShortEdges {
        public final Neighbors neighbors;
        public final double shortEdges;

        public NeighborWithShortEdges(Neighbors neighbors, double shortEdges) {
            this.neighbors = neighbors;
            this.shortEdges = shortEdges;
        }
    }

    private static class NeighborIterator
    extends NodesIterator {
        private final NodeArray neighbors;
        private int i;

        private NeighborIterator(NodeArray neighbors) {
            super(neighbors.size());
            this.neighbors = neighbors;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.neighbors.size();
        }

        @Override
        public int nextInt() {
            return this.neighbors.getNode(this.i++);
        }
    }
}

