/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.io.github.jbellis.jvector.disk;

import com.hazelcast.shaded.io.github.jbellis.jvector.disk.RandomAccessWriter;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.Path;
import java.util.zip.CRC32;

public class BufferedRandomAccessWriter
implements RandomAccessWriter {
    private final RandomAccessFile raf;
    private final DataOutputStream stream;

    public BufferedRandomAccessWriter(Path path) throws FileNotFoundException {
        this.raf = new RandomAccessFile(path.toFile(), "rw");
        this.stream = new DataOutputStream(new BufferedOutputStream(new RandomAccessOutputStream(this.raf)));
    }

    @Override
    public void seek(long position) throws IOException {
        this.flush();
        this.raf.seek(position);
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.stream.close();
        this.raf.close();
    }

    @Override
    public long position() throws IOException {
        this.flush();
        return this.raf.getFilePointer();
    }

    @Override
    public void flush() throws IOException {
        this.stream.flush();
    }

    @Override
    public long checksum(long startOffset, long endOffset) throws IOException {
        int read;
        this.flush();
        CRC32 crc = new CRC32();
        byte[] a2 = new byte[4096];
        this.seek(startOffset);
        for (long p = startOffset; p < endOffset; p += (long)read) {
            int toRead = (int)Math.min((long)a2.length, endOffset - p);
            read = this.raf.read(a2, 0, toRead);
            if (read < 0) {
                throw new IOException("EOF reached before endOffset");
            }
            crc.update(a2, 0, read);
        }
        return crc.getValue();
    }

    @Override
    public void write(int b) throws IOException {
        this.stream.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.stream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.stream.write(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.stream.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.stream.writeByte(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.stream.writeShort(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.stream.writeChar(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.stream.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.stream.writeLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.stream.writeFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.stream.writeDouble(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.stream.writeBytes(s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.stream.writeChars(s);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.stream.writeUTF(s);
    }

    private static class RandomAccessOutputStream
    extends OutputStream {
        private final RandomAccessFile raf;

        public RandomAccessOutputStream(RandomAccessFile raf) {
            this.raf = raf;
        }

        @Override
        public void write(int b) throws IOException {
            this.raf.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.raf.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            this.raf.close();
        }
    }
}

