/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.scheduledexecutor.impl.operations;

import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.scheduledexecutor.impl.ScheduledExecutorContainer;
import com.hazelcast.scheduledexecutor.impl.ScheduledTaskDescriptor;
import com.hazelcast.scheduledexecutor.impl.operations.AbstractSchedulerOperation;
import java.io.IOException;
import java.util.List;

public class MergeBackupOperation
extends AbstractSchedulerOperation {
    private List<ScheduledTaskDescriptor> descriptors;

    public MergeBackupOperation() {
    }

    MergeBackupOperation(String name, List<ScheduledTaskDescriptor> descriptors) {
        super(name);
        this.descriptors = descriptors;
    }

    @Override
    public void run() throws Exception {
        ScheduledExecutorContainer container = this.getContainer();
        for (ScheduledTaskDescriptor descriptor : this.descriptors) {
            container.enqueueSuspended(descriptor, true);
        }
    }

    @Override
    public int getClassId() {
        return 28;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        SerializationUtil.writeList(this.descriptors, out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.descriptors = SerializationUtil.readList(in);
    }
}

