/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.IndexType;
import com.hazelcast.core.TypeConverter;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.monitor.impl.GlobalIndexesStats;
import com.hazelcast.internal.monitor.impl.HDGlobalIndexesStats;
import com.hazelcast.internal.monitor.impl.IndexesStats;
import com.hazelcast.internal.monitor.impl.PartitionIndexesStats;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.IterableUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.map.impl.operation.steps.engine.Step;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.AttributeIndexRegistry;
import com.hazelcast.query.impl.CachedQueryEntry;
import com.hazelcast.query.impl.ConverterCache;
import com.hazelcast.query.impl.DefaultIndexProvider;
import com.hazelcast.query.impl.GlobalQueryContextProvider;
import com.hazelcast.query.impl.GlobalQueryContextProviderWithStats;
import com.hazelcast.query.impl.Index;
import com.hazelcast.query.impl.IndexCopyBehavior;
import com.hazelcast.query.impl.IndexProvider;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.query.impl.PartitionQueryContextProvider;
import com.hazelcast.query.impl.PartitionQueryContextProviderWithStats;
import com.hazelcast.query.impl.QueryContext;
import com.hazelcast.query.impl.QueryContextProvider;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.query.impl.predicates.IndexAwarePredicate;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class IndexRegistry {
    public static final int SKIP_PARTITIONS_COUNT_CHECK = -1;
    private static final InternalIndex[] EMPTY_INDEXES = new InternalIndex[0];
    private static final ThreadLocal<CachedQueryEntry[]> CACHED_ENTRIES = ThreadLocal.withInitial(() -> new CachedQueryEntry[]{new CachedQueryEntry(), new CachedQueryEntry()});
    private final Node node;
    private final String mapName;
    private final boolean global;
    private final boolean usesCachedQueryableEntries;
    private final IndexesStats stats;
    private final Extractors extractors;
    private final IndexProvider indexProvider;
    private final IndexCopyBehavior indexCopyBehavior;
    private final Supplier<java.util.function.Predicate<QueryableEntry>> resultFilterFactory;
    private final QueryContextProvider queryContextProvider;
    private final InternalSerializationService ss;
    private final Map<String, InternalIndex> indexesByName = new ConcurrentHashMap<String, InternalIndex>(3);
    private final AttributeIndexRegistry attributeIndexRegistry = new AttributeIndexRegistry();
    private final AttributeIndexRegistry evaluateOnlyAttributeIndexRegistry = new AttributeIndexRegistry();
    private final ConverterCache converterCache = new ConverterCache(this);
    private final Map<String, IndexConfig> definitions = new ConcurrentHashMap<String, IndexConfig>();
    private final int partitionCount;
    private final int partitionId;
    private volatile InternalIndex[] indexes = EMPTY_INDEXES;
    private volatile InternalIndex[] compositeIndexes = EMPTY_INDEXES;

    private IndexRegistry(Node node, String mapName, InternalSerializationService ss, IndexCopyBehavior indexCopyBehavior, Extractors extractors, IndexProvider indexProvider, boolean usesCachedQueryableEntries, boolean statisticsEnabled, boolean global, InMemoryFormat inMemoryFormat, int partitionCount, int partitionId, Supplier<java.util.function.Predicate<QueryableEntry>> resultFilterFactory) {
        this.node = node;
        this.mapName = mapName;
        this.global = global;
        this.indexCopyBehavior = indexCopyBehavior;
        this.ss = ss;
        this.usesCachedQueryableEntries = usesCachedQueryableEntries;
        this.stats = IndexRegistry.createStats(global, inMemoryFormat, statisticsEnabled);
        this.extractors = extractors == null ? Extractors.newBuilder(ss).build() : extractors;
        this.indexProvider = indexProvider == null ? new DefaultIndexProvider() : indexProvider;
        this.queryContextProvider = IndexRegistry.createQueryContextProvider(this, global, statisticsEnabled);
        this.partitionCount = partitionCount;
        this.partitionId = partitionId;
        this.resultFilterFactory = resultFilterFactory;
    }

    public static void beginPartitionUpdate(InternalIndex[] indexes) {
        for (InternalIndex index : indexes) {
            index.beginPartitionUpdate();
        }
    }

    public static void markPartitionAsIndexed(int partitionId, InternalIndex[] indexes) {
        for (InternalIndex index : indexes) {
            index.markPartitionAsIndexed(partitionId);
        }
    }

    public static void markPartitionAsUnindexed(int partitionId, InternalIndex[] indexes) {
        for (InternalIndex index : indexes) {
            index.markPartitionAsUnindexed(partitionId);
        }
    }

    public static Builder newBuilder(Node node, String mapName, SerializationService ss, IndexCopyBehavior indexCopyBehavior, InMemoryFormat inMemoryFormat) {
        return new Builder(node, mapName, ss, indexCopyBehavior, inMemoryFormat);
    }

    public synchronized InternalIndex addOrGetIndex(IndexConfig indexConfig) {
        String name = indexConfig.getName();
        assert (name != null);
        assert (!name.isEmpty());
        InternalIndex index = this.indexesByName.get(name);
        if (index != null) {
            return index;
        }
        index = this.indexProvider.createIndex(this.node, indexConfig, this.extractors, this.ss, this.indexCopyBehavior, this.stats.createPerIndexStats(indexConfig.getType() == IndexType.SORTED, this.usesCachedQueryableEntries), this.partitionCount, this.partitionId, this.mapName);
        this.indexesByName.put(name, index);
        if (index.isEvaluateOnly()) {
            this.evaluateOnlyAttributeIndexRegistry.register(index);
        } else {
            this.attributeIndexRegistry.register(index);
        }
        this.converterCache.invalidate(index);
        InternalIndex[] internalIndexes = this.indexesByName.values().toArray(EMPTY_INDEXES);
        Arrays.sort(internalIndexes, (o1, o2) -> {
            long ts1 = o1.getPerIndexStats().getCreationTime();
            long ts2 = o2.getPerIndexStats().getCreationTime();
            return Long.compare(ts1, ts2);
        });
        this.indexes = internalIndexes;
        if (index.getComponents().length > 1) {
            InternalIndex[] oldCompositeIndexes = this.compositeIndexes;
            InternalIndex[] newCompositeIndexes = Arrays.copyOf(oldCompositeIndexes, oldCompositeIndexes.length + 1);
            newCompositeIndexes[oldCompositeIndexes.length] = index;
            this.compositeIndexes = newCompositeIndexes;
        }
        return index;
    }

    public void recordIndexDefinition(IndexConfig config) {
        String name = config.getName();
        assert (name != null && !name.isEmpty());
        if (this.definitions.containsKey(name) || this.indexesByName.containsKey(name)) {
            return;
        }
        this.definitions.put(name, config);
    }

    public void createIndexesFromRecordedDefinitions() {
        this.definitions.forEach((name, indexConfig) -> {
            this.addOrGetIndex((IndexConfig)indexConfig);
            this.definitions.compute((String)name, (k, v) -> indexConfig == v ? null : v);
        });
    }

    public void getCustomStepAwareStorage(Consumer<Step> stepCollector) {
        for (int i = 0; i < this.indexes.length; ++i) {
            this.indexes[i].getCustomStepAwareStorage().collectCustomSteps(stepCollector);
        }
    }

    public String getMapName() {
        return this.mapName;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public InternalIndex[] getCompositeIndexes() {
        return this.compositeIndexes;
    }

    public Collection<IndexConfig> getIndexDefinitions() {
        return this.definitions.values();
    }

    public void destroyIndexes() {
        InternalIndex[] indexesCopy = this.indexes;
        this.indexes = EMPTY_INDEXES;
        this.compositeIndexes = EMPTY_INDEXES;
        this.indexesByName.clear();
        this.attributeIndexRegistry.clear();
        this.evaluateOnlyAttributeIndexRegistry.clear();
        this.converterCache.clear();
        for (InternalIndex index : indexesCopy) {
            index.destroy();
        }
        CACHED_ENTRIES.remove();
    }

    public void clearAll() {
        InternalIndex[] indexesCopy;
        for (InternalIndex index : indexesCopy = this.indexes) {
            index.clear();
        }
    }

    public boolean haveAtLeastOneIndex() {
        return this.indexes != EMPTY_INDEXES;
    }

    public boolean haveAtLeastOneIndexOrDefinition() {
        boolean haveAtLeastOneIndexOrDefinition;
        boolean bl = haveAtLeastOneIndexOrDefinition = this.haveAtLeastOneIndex() || !this.definitions.isEmpty();
        assert (this.isGlobal() || !haveAtLeastOneIndexOrDefinition || !this.haveAtLeastOneIndex() || this.definitions.isEmpty());
        return haveAtLeastOneIndexOrDefinition;
    }

    public void putEntry(QueryableEntry entryToStore, Object oldValue, Index.OperationSource operationSource) {
        CachedQueryEntry oldEntry;
        CachedQueryEntry newEntry;
        if (entryToStore instanceof CachedQueryEntry) {
            CachedQueryEntry entry = (CachedQueryEntry)entryToStore;
            if (oldValue == null) {
                this.putEntry(entry, null, entryToStore, operationSource);
                return;
            }
        }
        CachedQueryEntry[] cachedEntries = CACHED_ENTRIES.get();
        if (entryToStore instanceof CachedQueryEntry) {
            CachedQueryEntry entry;
            newEntry = entry = (CachedQueryEntry)entryToStore;
        } else {
            newEntry = cachedEntries[0];
            newEntry.init(this.ss, entryToStore.getKeyData(), entryToStore.getTargetObject(false), this.extractors);
        }
        if (oldValue == null) {
            oldEntry = null;
        } else {
            oldEntry = cachedEntries[1];
            oldEntry.init(this.ss, entryToStore.getKeyData(), oldValue, this.extractors);
        }
        this.putEntry(newEntry, oldEntry, entryToStore, operationSource);
    }

    public void putEntry(CachedQueryEntry newEntry, CachedQueryEntry oldEntry, QueryableEntry entryToStore, Index.OperationSource operationSource) {
        InternalIndex[] indexesCopy;
        Exception exception = null;
        for (InternalIndex index : indexesCopy = this.indexes) {
            try {
                index.putEntry(newEntry, oldEntry, entryToStore, operationSource);
            }
            catch (Exception t) {
                if (exception != null) continue;
                exception = t;
            }
        }
        if (exception != null) {
            throw ExceptionUtil.rethrow(exception);
        }
    }

    public void removeEntry(Data key, Object value, Index.OperationSource operationSource) {
        CachedQueryEntry entry = CACHED_ENTRIES.get()[0];
        entry.init(this.ss, key, value, this.extractors);
        this.removeEntry(entry, operationSource);
    }

    public void removeEntry(CachedQueryEntry entry, Index.OperationSource operationSource) {
        InternalIndex[] indexesCopy;
        for (InternalIndex index : indexesCopy = this.indexes) {
            index.removeEntry(entry, operationSource);
        }
    }

    public boolean isGlobal() {
        return this.global;
    }

    public InternalIndex getIndex(String name) {
        return this.indexesByName.get(name);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public InternalIndex[] getIndexes() {
        return this.indexes;
    }

    public Iterable<QueryableEntry> query(Predicate predicate, int ownedPartitionCount) {
        this.stats.incrementQueryCount();
        if (!(predicate instanceof IndexAwarePredicate)) {
            this.stats.incrementIndexesSkippedQueryCount();
            return null;
        }
        if (!this.haveAtLeastOneIndex()) {
            return null;
        }
        IndexAwarePredicate indexAwarePredicate = (IndexAwarePredicate)predicate;
        QueryContext queryContext = this.queryContextProvider.obtainContextFor(this, ownedPartitionCount);
        if (!indexAwarePredicate.isIndexed(queryContext)) {
            return null;
        }
        Set<QueryableEntry> result = indexAwarePredicate.filter(queryContext);
        if (result != null) {
            this.stats.incrementIndexedQueryCount();
            queryContext.applyPerQueryStats();
        }
        if (result != null && this.resultFilterFactory != null) {
            return IterableUtil.filter(result, this.resultFilterFactory.get());
        }
        return result;
    }

    public InternalIndex matchIndex(String pattern, QueryContext.IndexMatchHint matchHint, int ownedPartitionCount) {
        InternalIndex index = matchHint == QueryContext.IndexMatchHint.EXACT_NAME ? this.indexesByName.get(pattern) : this.attributeIndexRegistry.match(pattern, matchHint);
        if (index == null) {
            this.stats.incrementNoMatchingIndexQueryCount();
            return null;
        }
        if (!index.allPartitionsIndexed(ownedPartitionCount)) {
            index.getPerIndexStats().incrementIndexNotReadyQueryCount();
            return null;
        }
        return index;
    }

    public InternalIndex matchIndex(String pattern, Class<? extends Predicate> predicateClass, QueryContext.IndexMatchHint matchHint, int ownedPartitionCount) {
        InternalIndex index;
        if (matchHint == QueryContext.IndexMatchHint.EXACT_NAME) {
            index = this.indexesByName.get(pattern);
        } else {
            index = this.evaluateOnlyAttributeIndexRegistry.match(pattern, matchHint);
            if (index == null) {
                index = this.attributeIndexRegistry.match(pattern, matchHint);
            }
        }
        if (index == null) {
            return null;
        }
        if (!index.canEvaluate(predicateClass)) {
            return null;
        }
        if (!index.allPartitionsIndexed(ownedPartitionCount)) {
            return null;
        }
        return index;
    }

    public TypeConverter getConverter(String attribute) {
        return this.converterCache.get(attribute);
    }

    public IndexesStats getIndexesStats() {
        return this.stats;
    }

    private static QueryContextProvider createQueryContextProvider(IndexRegistry indexes, boolean global, boolean statisticsEnabled) {
        if (statisticsEnabled) {
            return global ? new GlobalQueryContextProviderWithStats() : new PartitionQueryContextProviderWithStats(indexes);
        }
        return global ? new GlobalQueryContextProvider() : new PartitionQueryContextProvider(indexes);
    }

    private static IndexesStats createStats(boolean global, InMemoryFormat inMemoryFormat, boolean statisticsEnabled) {
        if (statisticsEnabled) {
            if (global) {
                return inMemoryFormat == InMemoryFormat.NATIVE ? new HDGlobalIndexesStats() : new GlobalIndexesStats();
            }
            return new PartitionIndexesStats();
        }
        return IndexesStats.EMPTY;
    }

    public static final class Builder {
        private final IndexCopyBehavior indexCopyBehavior;
        private final InternalSerializationService serializationService;
        private boolean global = true;
        private boolean statsEnabled;
        private boolean usesCachedQueryableEntries;
        private int partitionCount;
        private int partitionId = -1;
        private Extractors extractors;
        private IndexProvider indexProvider;
        private InMemoryFormat inMemoryFormat;
        private String mapName;
        private Node node;
        private Supplier<java.util.function.Predicate<QueryableEntry>> resultFilterFactory;

        Builder(Node node, String mapName, SerializationService ss, IndexCopyBehavior indexCopyBehavior, InMemoryFormat inMemoryFormat) {
            this.serializationService = Preconditions.checkNotNull((InternalSerializationService)ss, "serializationService cannot be null");
            this.indexCopyBehavior = Preconditions.checkNotNull(indexCopyBehavior, "indexCopyBehavior cannot be null");
            this.inMemoryFormat = inMemoryFormat;
            this.mapName = mapName;
            this.node = node;
        }

        public Builder resultFilterFactory(Supplier<java.util.function.Predicate<QueryableEntry>> filterFactory) {
            this.resultFilterFactory = filterFactory;
            return this;
        }

        public Builder global(boolean global) {
            this.global = global;
            return this;
        }

        public Builder indexProvider(IndexProvider indexProvider) {
            this.indexProvider = indexProvider;
            return this;
        }

        public Builder extractors(Extractors extractors) {
            this.extractors = extractors;
            return this;
        }

        public Builder usesCachedQueryableEntries(boolean usesCachedQueryableEntries) {
            this.usesCachedQueryableEntries = usesCachedQueryableEntries;
            return this;
        }

        public Builder statsEnabled(boolean statsEnabled) {
            this.statsEnabled = statsEnabled;
            return this;
        }

        public Builder partitionCount(int partitionCount) {
            this.partitionCount = partitionCount;
            return this;
        }

        public Builder partitionId(int partitionId) {
            this.partitionId = partitionId;
            return this;
        }

        public IndexRegistry build() {
            return new IndexRegistry(this.node, this.mapName, this.serializationService, this.indexCopyBehavior, this.extractors, this.indexProvider, this.usesCachedQueryableEntries, this.statsEnabled, this.global, this.inMemoryFormat, this.partitionCount, this.partitionId, this.resultFilterFactory);
        }
    }
}

