/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.internal.bplustree.DefaultBPlusTreeKeyComparator;
import com.hazelcast.internal.bplustree.EntrySlotNoPayload;
import com.hazelcast.internal.elastic.tree.MapEntryFactory;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.query.impl.AbstractIndex;
import com.hazelcast.query.impl.Comparables;
import com.hazelcast.query.impl.Comparison;
import com.hazelcast.query.impl.HDBaseConcurrentIndexStore;
import com.hazelcast.query.impl.IndexCopyBehavior;
import com.hazelcast.query.impl.IndexKeyEntries;
import com.hazelcast.query.impl.QueryableEntry;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;

public class HDOrderedConcurrentIndexStore
extends HDBaseConcurrentIndexStore {
    HDOrderedConcurrentIndexStore(IndexCopyBehavior copyBehavior, EnterpriseSerializationService ess, MemoryAllocator keyAllocator, Function<String, MemoryAllocator> indexAllocatorConstructor, MapEntryFactory<QueryableEntry> entryFactory, int nodeSize, String indexName, boolean tstore) {
        super(copyBehavior, ess, keyAllocator, indexAllocatorConstructor, new DefaultBPlusTreeKeyComparator(ess), entryFactory, nodeSize, new EntrySlotNoPayload(), indexName, tstore);
    }

    @Override
    public Iterator<IndexKeyEntries> getSqlRecordIteratorBatch(Comparable value, boolean descending) {
        return this.getSqlRecordIteratorBatch(value, true, value, true, descending, null);
    }

    @Override
    public Iterator<IndexKeyEntries> getSqlRecordIteratorBatch(Comparable value, boolean descending, Data key) {
        boolean fromInclusive0 = key == null || descending;
        boolean toInclusive0 = key == null || !descending;
        return this.records.getKeysInRangeBatch(value, fromInclusive0, value, toInclusive0, descending, key);
    }

    @Override
    public Iterator<IndexKeyEntries> getSqlRecordIteratorBatch(boolean descending) {
        return this.records.getKeysInRangeBatch(null, true, null, true, descending);
    }

    @Override
    public Iterator<IndexKeyEntries> getSqlRecordIteratorBatch(Comparison comparison, Comparable value, boolean descending, Data key) {
        switch (comparison) {
            case LESS: {
                return this.getSqlRecordIteratorBatch(AbstractIndex.NULL, false, value, false, descending, key);
            }
            case LESS_OR_EQUAL: {
                return this.getSqlRecordIteratorBatch(AbstractIndex.NULL, false, value, true, descending, key);
            }
            case GREATER: {
                return this.getSqlRecordIteratorBatch(value, false, null, true, descending, key);
            }
            case GREATER_OR_EQUAL: {
                return this.getSqlRecordIteratorBatch(value, true, null, true, descending, key);
            }
        }
        throw new IllegalArgumentException("Unrecognized comparison: " + String.valueOf((Object)comparison));
    }

    @Override
    public Iterator<IndexKeyEntries> getSqlRecordIteratorBatch(Comparison comparison, Comparable value, boolean descending) {
        return this.getSqlRecordIteratorBatch(comparison, value, descending, null);
    }

    @Override
    public Iterator<IndexKeyEntries> getSqlRecordIteratorBatch(Comparable from, boolean fromInclusive, Comparable to, boolean toInclusive, boolean descending) {
        return this.getSqlRecordIteratorBatch(from, fromInclusive, to, toInclusive, descending, null);
    }

    @Override
    public Iterator<IndexKeyEntries> getSqlRecordIteratorBatch(Comparable from, boolean fromInclusive, Comparable to, boolean toInclusive, boolean descending, Data key) {
        boolean fromInclusive0 = fromInclusive;
        boolean toInclusive0 = toInclusive;
        if (key != null) {
            fromInclusive0 = descending && fromInclusive0;
            toInclusive0 = !descending && toInclusive0;
        }
        return this.records.getKeysInRangeBatch(from, fromInclusive0, to, toInclusive0, descending, key);
    }

    @Override
    public Set<QueryableEntry> getRecords(Comparable from, boolean fromInclusive, Comparable to, boolean toInclusive) {
        return this.buildResultSet(this.getRecords0(from, fromInclusive, to, toInclusive, false));
    }

    @Override
    public Comparable canonicalizeQueryArgumentScalar(Comparable value) {
        return Comparables.canonicalizeForHashLookup(value);
    }

    @Override
    public Comparable canonicalizeScalarForStorage(Comparable value) {
        return value;
    }
}

