/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.config.IndexConfig;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.memory.GlobalIndexPoolingAllocator;
import com.hazelcast.internal.memory.HazelcastMemoryManager;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.memory.PoolingMemoryManager;
import com.hazelcast.internal.monitor.impl.PerIndexStats;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.query.impl.HDOrderedConcurrentIndexStore;
import com.hazelcast.query.impl.HDUnorderedConcurrentIndexStore;
import com.hazelcast.query.impl.IndexCopyBehavior;
import com.hazelcast.query.impl.IndexImpl;
import com.hazelcast.query.impl.IndexStore;
import com.hazelcast.query.impl.OnHeapEntryFactory;
import com.hazelcast.query.impl.getters.Extractors;

public class HDGlobalIndexImpl
extends IndexImpl {
    public HDGlobalIndexImpl(Node node, IndexConfig config, EnterpriseSerializationService ss, Extractors extractors, PerIndexStats stats, int partitionCount, String mapName) {
        super(node, config, (InternalSerializationService)ss, extractors, IndexCopyBehavior.NEVER, stats, partitionCount, mapName);
    }

    @Override
    protected IndexStore createIndexStore(Node node, IndexConfig config, PerIndexStats stats, String mapName, int ignored) {
        EnterpriseSerializationService ess = (EnterpriseSerializationService)this.ss;
        HazelcastMemoryManager memoryManager = ess.getMemoryManager();
        if (!(memoryManager instanceof PoolingMemoryManager)) {
            throw new IllegalArgumentException("HD global indices require Pooling Memory Manager");
        }
        PoolingMemoryManager poolingMemoryManager = (PoolingMemoryManager)memoryManager;
        MemoryAllocator wrappedKeyAllocator = stats.wrapMemoryAllocator(poolingMemoryManager);
        GlobalIndexPoolingAllocator indexAllocator = poolingMemoryManager.getGlobalIndexAllocator();
        MemoryAllocator wrappedIndexAllocator = stats.wrapMemoryAllocator(indexAllocator);
        OnHeapEntryFactory entryFactory = new OnHeapEntryFactory(ess, this.extractors);
        int nodeSize = indexAllocator.getNodeSize();
        String indexName = config.getName();
        switch (config.getType()) {
            case SORTED: {
                return new HDOrderedConcurrentIndexStore(this.copyBehavior, ess, wrappedKeyAllocator, tag -> wrappedIndexAllocator, entryFactory, nodeSize, indexName, false);
            }
            case HASH: {
                return new HDUnorderedConcurrentIndexStore(this.copyBehavior, ess, wrappedKeyAllocator, tag -> wrappedIndexAllocator, entryFactory, nodeSize, indexName, false);
            }
            case BITMAP: {
                throw new IllegalArgumentException("Bitmap indexes are not supported by NATIVE storage");
            }
        }
        throw new IllegalArgumentException("unexpected index type: " + String.valueOf((Object)config.getType()));
    }

    @Override
    public void destroy() {
        this.indexStore.destroy();
        super.destroy();
    }

    @Override
    public String toString() {
        return "HDGlobalIndexImpl{} " + super.toString();
    }
}

