/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.impl.operations;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.multimap.impl.MultiMapContainer;
import com.hazelcast.multimap.impl.MultiMapRecord;
import com.hazelcast.multimap.impl.MultiMapValue;
import com.hazelcast.multimap.impl.operations.AbstractMultiMapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class MergeBackupOperation
extends AbstractMultiMapOperation
implements BackupOperation {
    private Map<Data, Collection<MultiMapRecord>> backupEntries;

    public MergeBackupOperation() {
    }

    MergeBackupOperation(String name, Map<Data, Collection<MultiMapRecord>> backupEntries) {
        super(name);
        this.backupEntries = backupEntries;
    }

    @Override
    public void run() throws Exception {
        this.response = true;
        MultiMapContainer container = this.getOrCreateContainerWithoutAccess();
        for (Map.Entry<Data, Collection<MultiMapRecord>> entry : this.backupEntries.entrySet()) {
            Data key = entry.getKey();
            Collection<MultiMapRecord> value = entry.getValue();
            if (value.isEmpty()) {
                container.remove(key, false);
                continue;
            }
            MultiMapValue containerValue = container.getOrCreateMultiMapValue(key);
            Collection<MultiMapRecord> collection = containerValue.getCollection(false);
            collection.clear();
            if (collection.addAll(value)) continue;
            this.response = false;
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.backupEntries.size());
        for (Map.Entry<Data, Collection<MultiMapRecord>> entry : this.backupEntries.entrySet()) {
            IOUtil.writeData(out, entry.getKey());
            Collection<MultiMapRecord> collection = entry.getValue();
            SerializationUtil.writeCollection(collection, out);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        this.backupEntries = MapUtil.createHashMap(size);
        for (int i = 0; i < size; ++i) {
            Data key = IOUtil.readData(in);
            int collectionSize = in.readInt();
            ArrayList<MultiMapRecord> collection = new ArrayList<MultiMapRecord>(collectionSize);
            for (int j = 0; j < collectionSize; ++j) {
                MultiMapRecord record = (MultiMapRecord)in.readObject();
                collection.add(record);
            }
            this.backupEntries.put(key, collection);
        }
    }

    @Override
    public int getClassId() {
        return 50;
    }
}

