/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.instance.impl.EnterpriseNodeExtension;
import com.hazelcast.internal.hidensity.HiDensityStorageInfo;
import com.hazelcast.internal.hidensity.impl.TieredStoreRecordProcessor;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.tstore.Epoch;
import com.hazelcast.internal.tstore.State;
import com.hazelcast.internal.tstore.hybridlog.HybridLog;
import com.hazelcast.internal.tstore.index.Index;
import com.hazelcast.internal.tstore.service.TStoreUserId;
import com.hazelcast.internal.tstore.service.TieredStoreService;
import com.hazelcast.internal.tstore.service.TieredStoreUser;
import com.hazelcast.internal.tstore.service.impl.TieredStoreServiceImpl;
import com.hazelcast.internal.util.ToHeapDataConverter;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.EnterpriseMapContainer;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapKeyLoader;
import com.hazelcast.map.impl.NotifiableIterator;
import com.hazelcast.map.impl.operation.MutableMapEntry;
import com.hazelcast.map.impl.record.GuardedTieredStoreRecordAccessor;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordFactory;
import com.hazelcast.map.impl.record.Records;
import com.hazelcast.map.impl.record.TieredStoreRecord;
import com.hazelcast.map.impl.record.TieredStoreRecordFactory;
import com.hazelcast.map.impl.recordstore.EnterpriseBaseRecordStore;
import com.hazelcast.map.impl.recordstore.JsonMetadataStore;
import com.hazelcast.map.impl.recordstore.Storage;
import com.hazelcast.map.impl.recordstore.TieredStorageImpl;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryMetadata;
import com.hazelcast.map.impl.recordstore.expiry.ExpirySystem;
import com.hazelcast.spi.impl.NodeEngine;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class EnterpriseTieredRecordStore
extends EnterpriseBaseRecordStore {
    private final Epoch epoch;

    public EnterpriseTieredRecordStore(MapContainer mapContainer, int partitionId, MapKeyLoader keyLoader, ILogger logger) {
        super(mapContainer, partitionId, keyLoader, logger);
        TieredStoreServiceImpl tieredStoreService = this.getTieredStoreServiceImpl();
        this.epoch = tieredStoreService.getEpoch(mapContainer, partitionId);
    }

    private TieredStoreServiceImpl getTieredStoreServiceImpl() {
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        EnterpriseNodeExtension nodeExtension = (EnterpriseNodeExtension)nodeEngine.getNode().getNodeExtension();
        return (TieredStoreServiceImpl)nodeExtension.getTieredStoreService();
    }

    @Override
    RecordFactory createRecordFactory() {
        return new TieredStoreRecordFactory(this.mapContainer, this.createTieredStoreRecordProcessor(), this.epoch);
    }

    private TieredStoreRecordProcessor createTieredStoreRecordProcessor() {
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        EnterpriseSerializationService ss = (EnterpriseSerializationService)nodeEngine.getSerializationService();
        GuardedTieredStoreRecordAccessor recordAccessor = new GuardedTieredStoreRecordAccessor(ss, this.mapContainer, this.getPartitionId());
        return new TieredStoreRecordProcessor(ss, recordAccessor, this.epoch);
    }

    @Override
    protected JsonMetadataStore createMetadataStore() {
        return JsonMetadataStore.NULL;
    }

    @Override
    public EvictionPolicy getEvictionPolicy() {
        return EvictionPolicy.NONE;
    }

    @Override
    @Nonnull
    protected ExpirySystem createExpirySystem(MapContainer mapContainer) {
        return ExpirySystem.NULL;
    }

    @Override
    public Storage createStorage(RecordFactory recordFactory, InMemoryFormat memoryFormat) {
        assert (InMemoryFormat.NATIVE == this.inMemoryFormat);
        TieredStoreRecordFactory tieredStoreRecordFactory = (TieredStoreRecordFactory)recordFactory;
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        EnterpriseNodeExtension nodeExtension = (EnterpriseNodeExtension)nodeEngine.getNode().getNodeExtension();
        TieredStoreService tieredStoreService = nodeExtension.getTieredStoreService();
        TStoreUserId userId = new TStoreUserId(TieredStoreUser.IMAP, this.name);
        HiDensityStorageInfo hdStorageInfo = ((EnterpriseMapContainer)this.mapContainer).getHDStorageInfo();
        return new TieredStorageImpl(userId, this.partitionId, tieredStoreRecordFactory, this.epoch, this.memoryManager, this.statsEnabled, hdStorageInfo, () -> {
            String deviceName = this.mapContainer.getMapConfig().getTieredStoreConfig().getDiskTierConfig().getDeviceName();
            return tieredStoreService.getOrNullCompactionManager(deviceName);
        }, nodeEngine.getProperties());
    }

    public Epoch getEpoch() {
        return this.epoch;
    }

    @Override
    public TieredStoreRecord createRecord(Data key, Object value, long now) {
        return (TieredStoreRecord)super.createRecord(key, value, now);
    }

    @Override
    public Record putMemory(Record record, Data key, Object oldValue, long ttl, long maxIdle, long expiryTime, long now, EntryEventType entryEventType, boolean backup) {
        assert (this.expirySystem == ExpirySystem.NULL);
        EnterpriseTieredRecordStore.checkTtlAndMaxIdle(ttl, maxIdle);
        boolean pinned = ((TieredStoreRecord)record).pin();
        assert (pinned);
        Index.KeyLock keyLock = null;
        try {
            this.storage.put(key, record);
            keyLock = this.lockKey(key);
            this.mutationObserver.onPutRecord(key, record, oldValue, backup);
            Record record2 = record;
            if (keyLock != null) {
                this.unlockKey(keyLock, false);
            }
            ((TieredStoreRecord)record).unpin();
            return record2;
        }
        catch (Throwable t) {
            try {
                this.logger.severe(t.getMessage(), t);
                throw t;
            }
            catch (Throwable throwable) {
                if (keyLock != null) {
                    this.unlockKey(keyLock, false);
                }
                ((TieredStoreRecord)record).unpin();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object updateMemory(Record record, Data key, Object oldValue, Object newValue, boolean changeExpiryOnUpdate, long ttl, long maxIdle, long expiryTime, long now, boolean backup) {
        assert (this.expirySystem == ExpirySystem.NULL);
        EnterpriseTieredRecordStore.checkTtlAndMaxIdle(ttl, maxIdle);
        Data oldValueHeapData = this.toData(oldValue);
        Data newValueData = this.toData(newValue);
        Index.KeyLock keyLock = this.lockKey(key);
        try {
            TieredStoreRecord newRecord = (TieredStoreRecord)this.storage.updateRecordValue(key, record, newValueData);
            boolean pinned = newRecord.pin();
            assert (pinned);
            try {
                this.mutationObserver.onUpdateRecord(key, newRecord, oldValueHeapData, newValueData, backup);
                Data data = oldValueHeapData;
                newRecord.unpin();
                return data;
            }
            catch (Throwable throwable) {
                try {
                    newRecord.unpin();
                    throw throwable;
                }
                catch (Throwable t) {
                    this.logger.severe(t.getMessage(), t);
                    throw t;
                }
            }
        }
        finally {
            this.unlockKey(keyLock, false);
        }
    }

    @Override
    public Record putOrUpdateReplicatedRecord(Data dataKey, Record replicatedRecord, ExpiryMetadata expiryMetadata, boolean indexesMustBePopulated, long now) {
        assert (this.expirySystem == ExpirySystem.NULL);
        TieredStoreRecord newRecord = (TieredStoreRecord)this.storage.get(dataKey);
        boolean pinnedNewRecord = false;
        Index.KeyLock keyLock = null;
        try {
            if (newRecord == null) {
                newRecord = this.createRecord(dataKey, replicatedRecord != null ? replicatedRecord.getValue() : null, now);
                Records.copyMetadataFrom(replicatedRecord, newRecord);
                pinnedNewRecord = newRecord.pin();
                assert (pinnedNewRecord);
                this.storage.put(dataKey, newRecord);
                keyLock = this.lockKey(dataKey);
            } else {
                keyLock = this.lockKey(dataKey);
                Records.copyMetadataFrom(replicatedRecord, newRecord);
                newRecord = this.storage.updateRecordValue(dataKey, newRecord, replicatedRecord.getValue());
                pinnedNewRecord = newRecord.pin();
                assert (pinnedNewRecord);
            }
            this.mutationObserver.onReplicationPutRecord(dataKey, newRecord, indexesMustBePopulated);
            TieredStoreRecord tieredStoreRecord = newRecord;
            return tieredStoreRecord;
        }
        catch (Throwable t) {
            this.logger.severe(t.getMessage(), t);
            throw t;
        }
        finally {
            if (keyLock != null) {
                this.unlockKey(keyLock, false);
            }
            if (pinnedNewRecord) {
                newRecord.unpin();
            }
        }
    }

    @Override
    public void removeRecord0(Data key, @Nonnull Record record, boolean backup) {
        Index.KeyLock keyLock = this.lockKey(key);
        try {
            super.removeRecord0(key, record, backup);
        }
        catch (Throwable t) {
            this.logger.severe(t.getMessage(), t);
            throw t;
        }
        finally {
            this.unlockKey(keyLock, true);
        }
    }

    @Override
    public void removeByKey(Data key, boolean backup) {
        Index.KeyLock keyLock = this.lockKey(key);
        try {
            TieredStorageImpl.RecordInfo recordInfo = this.getStorage().getNoCaching(key);
            Record record = recordInfo.getRecord();
            long logicalAddress = recordInfo.getLogicalAddress();
            int recordSize = recordInfo.getSize();
            this.mutationObserver.onRemoveRecord(key, record, backup);
            this.removeKeyFromExpirySystem(key);
            this.onStore(record);
            this.getStorage().removeRecord(key, logicalAddress, recordSize);
        }
        catch (Throwable t) {
            this.logger.severe(t.getMessage(), t);
            throw t;
        }
        finally {
            this.unlockKey(keyLock, true);
        }
    }

    @Override
    public Record getRecordOrNull(Data key, long now, boolean backup, boolean noCaching) {
        if (noCaching) {
            TieredStorageImpl.RecordInfo recordInfo = this.getStorage().getNoCaching(key);
            return recordInfo == null ? null : recordInfo.getRecord();
        }
        TieredStoreRecord record = this.getStorage().get(key);
        if (record != null) {
            return this.evictIfExpired(key, now, backup) ? null : record;
        }
        return null;
    }

    @Override
    public void forEach(BiConsumer<Data, Record> consumer, boolean backup, boolean includeExpiredRecords, boolean noCaching) {
        if (noCaching) {
            Iterator<Map.Entry<Data, Record<Data>>> entries = this.getStorage().mapEntryNoCachingIterator();
            while (entries.hasNext()) {
                Map.Entry<Data, Record<Data>> entry = entries.next();
                Data key = entry.getKey();
                Record<Data> record = entry.getValue();
                consumer.accept(key, record);
            }
        } else {
            Iterator<Map.Entry<Data, TieredStoreRecord>> entries = this.getStorage().mutationTolerantIterator();
            while (entries.hasNext()) {
                Map.Entry<Data, TieredStoreRecord> entry = entries.next();
                Data key = entry.getKey();
                Record record = entry.getValue();
                consumer.accept(key, record);
            }
        }
    }

    @Override
    public TieredStorageImpl getStorage() {
        return (TieredStorageImpl)super.getStorage();
    }

    @Override
    public int beforeOperation() {
        return this.storage.beforeOperation();
    }

    @Override
    public void afterOperation(int threadIndex) {
        this.storage.afterOperation(threadIndex);
    }

    @Override
    public void afterOperation() {
        int currentThreadIndex = this.epoch.getCurrentThreadIndex();
        this.afterOperation(currentThreadIndex);
    }

    public State getState() {
        return this.getStorage().getState();
    }

    public Index getIndex() {
        return this.getStorage().getIndex();
    }

    public TieredStoreRecordProcessor getRecordProcessor() {
        return this.getStorage().getRecordProcessor();
    }

    public Supplier<HybridLog> getHybridLogSupplier() {
        return this.getRecordProcessor().getHybridLogSupplier();
    }

    private Index.KeyLock lockKey(Data key) {
        int threadIndex = this.epoch.getCurrentThreadIndex();
        Index.KeyLock keyLock = this.getStorage().getIndex().lock(threadIndex, key);
        assert (keyLock != null);
        return keyLock;
    }

    private void unlockKey(Index.KeyLock keyLock, boolean remove) {
        int threadIndex = this.epoch.getCurrentThreadIndex();
        this.getStorage().getIndex().unlock(threadIndex, keyLock, remove);
    }

    @Override
    public int removeBulk(List<Data> dataKeys, List<Record> records, boolean backup) {
        return this.removeOrEvictEntries(dataKeys, false, backup);
    }

    @Override
    public int evictBulk(List<Data> dataKeys, List<Record> records, boolean backup) {
        return this.removeOrEvictEntries(dataKeys, true, backup);
    }

    private int removeOrEvictEntries(List<Data> dataKeys, boolean eviction, boolean backup) {
        int removedKeyCount = 0;
        for (int i = 0; i < dataKeys.size(); ++i) {
            Data key = dataKeys.get(i);
            TieredStorageImpl.RecordInfo recordInfo = this.getStorage().getNoCaching(key);
            this.removeOrEvictEntry(key, recordInfo, eviction, backup);
            ++removedKeyCount;
        }
        return removedKeyCount;
    }

    private void removeOrEvictEntry(Data dataKey, TieredStorageImpl.RecordInfo recordInfo, boolean eviction, boolean backup) {
        Record record = recordInfo.getRecord();
        if (eviction) {
            this.mutationObserver.onEvictRecord(dataKey, record, backup);
        } else {
            this.mutationObserver.onRemoveRecord(dataKey, record, backup);
        }
        long recordAddress = recordInfo.getLogicalAddress();
        int recordSize = recordInfo.getSize();
        this.removeKeyFromExpirySystem(dataKey);
        this.getStorage().removeRecord(dataKey, recordAddress, recordSize);
        if (this.wanReplicateEvictions && eviction) {
            this.mapEventPublisher.publishWanRemove(this.name, ToHeapDataConverter.toHeapData(dataKey));
        }
    }

    @Override
    public void disposeOnSplitBrainHeal() {
        try {
            this.getTieredStoreServiceImpl().getMetrics().deregisterMap(this.mapContainer);
            if (this.mapServiceContext.isForciblyEnabledGlobalIndex() && !this.epoch.isClosed()) {
                this.epoch.close();
            }
        }
        finally {
            super.disposeOnSplitBrainHeal();
        }
    }

    @Override
    public Iterator<Map.Entry<Data, Record>> iterator() {
        return new AdaptedNoCachingIterator(this.getStorage().mapEntryNoCachingIterator());
    }

    @Override
    public Object copyToHeapWhenNeeded(Object value) {
        return this.mapServiceContext.toData(value);
    }

    public CompletableFuture<Void> flushAndSyncState() {
        return this.getStorage().flushAndSyncState();
    }

    private static void checkTtlAndMaxIdle(long ttl, long maxIdle) {
        if (ttl != -1L && ttl != Long.MAX_VALUE && ttl != 0L) {
            throw new UnsupportedOperationException("TTL-based expiration is not supported by Tiered Store.");
        }
        if (maxIdle != -1L && maxIdle != Long.MAX_VALUE && maxIdle != 0L) {
            throw new UnsupportedOperationException("Max-Idle expiration is not supported by Tiered Store.");
        }
    }

    private static class AdaptedNoCachingIterator
    implements Iterator<Map.Entry<Data, Record>>,
    NotifiableIterator {
        final Iterator<Map.Entry<Data, Record<Data>>> iterator;
        final MutableMapEntry<Data, Record> cachedEntry = new MutableMapEntry();

        AdaptedNoCachingIterator(Iterator<Map.Entry<Data, Record<Data>>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<Data, Record> next() {
            Map.Entry<Data, Record<Data>> entry = this.iterator.next();
            this.cachedEntry.init(entry.getKey(), entry.getValue());
            return this.cachedEntry;
        }

        @Override
        public void onBeforeIteration() {
            Iterator<Map.Entry<Data, Record<Data>>> iterator = this.iterator;
            if (iterator instanceof NotifiableIterator) {
                NotifiableIterator notifiableIterator = (NotifiableIterator)((Object)iterator);
                notifiableIterator.onBeforeIteration();
            }
        }
    }
}

