/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.config.HotRestartConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.internal.hidensity.HiDensityRecordProcessor;
import com.hazelcast.internal.hidensity.HiDensityStorageInfo;
import com.hazelcast.internal.hidensity.impl.DefaultHiDensityRecordProcessor;
import com.hazelcast.internal.hotrestart.RamStore;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.EnterpriseMapContainer;
import com.hazelcast.map.impl.EnterpriseMapServiceContext;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapKeyLoader;
import com.hazelcast.map.impl.record.HDMapRecordAccessor;
import com.hazelcast.map.impl.record.HDRecord;
import com.hazelcast.map.impl.record.HDRecordFactory;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordFactory;
import com.hazelcast.map.impl.recordstore.EnterpriseBaseRecordStore;
import com.hazelcast.map.impl.recordstore.HDJsonMetadataStorageImpl;
import com.hazelcast.map.impl.recordstore.HDMapRamStoreImpl;
import com.hazelcast.map.impl.recordstore.HDStorageImpl;
import com.hazelcast.map.impl.recordstore.HotRestartHDStorageImpl;
import com.hazelcast.map.impl.recordstore.HotRestartStorage;
import com.hazelcast.map.impl.recordstore.HotRestartStorageImpl;
import com.hazelcast.map.impl.recordstore.JsonMetadataStore;
import com.hazelcast.map.impl.recordstore.OnHeapMapRamStoreImpl;
import com.hazelcast.map.impl.recordstore.Storage;
import com.hazelcast.map.impl.recordstore.expiry.ExpirySystem;
import com.hazelcast.map.impl.recordstore.expiry.HDExpirySystemImpl;
import com.hazelcast.spi.impl.NodeEngine;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;

public class EnterpriseRecordStore
extends EnterpriseBaseRecordStore {
    private final long prefix;
    private final HotRestartConfig hotRestartConfig;
    private RamStore ramStore;
    private boolean iterationInProgress;

    public EnterpriseRecordStore(MapContainer mapContainer, int partitionId, MapKeyLoader keyLoader, ILogger logger, HotRestartConfig hotRestartConfig, long prefix) {
        super(mapContainer, partitionId, keyLoader, logger);
        this.prefix = prefix;
        this.hotRestartConfig = hotRestartConfig;
    }

    @Override
    RecordFactory createRecordFactory() {
        if (InMemoryFormat.NATIVE == this.inMemoryFormat) {
            return new HDRecordFactory(this.mapContainer, this.createHiDensityRecordProcessor());
        }
        return super.createRecordFactory();
    }

    private HiDensityRecordProcessor<HDRecord> createHiDensityRecordProcessor() {
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        EnterpriseSerializationService ss = (EnterpriseSerializationService)nodeEngine.getSerializationService();
        HDMapRecordAccessor recordAccessor = new HDMapRecordAccessor(ss, this.mapContainer);
        return new DefaultHiDensityRecordProcessor<HDRecord>(ss, recordAccessor, ss.getMemoryManager(), ((EnterpriseMapContainer)this.mapContainer).getHDStorageInfo());
    }

    @Override
    protected JsonMetadataStore createMetadataStore() {
        if (this.inMemoryFormat == InMemoryFormat.NATIVE) {
            HiDensityStorageInfo hdStorageInfo = ((EnterpriseMapContainer)this.mapContainer).getHDStorageInfo();
            return new HDJsonMetadataStorageImpl((EnterpriseSerializationService)this.serializationService, hdStorageInfo);
        }
        return super.createMetadataStore();
    }

    @Override
    public void init() {
        super.init();
        if (this.prefix != -1L) {
            this.ramStore = this.inMemoryFormat == InMemoryFormat.NATIVE ? new HDMapRamStoreImpl(this, this.memoryManager) : new OnHeapMapRamStoreImpl(this);
        }
    }

    @Override
    @Nonnull
    protected ExpirySystem createExpirySystem(MapContainer mapContainer) {
        if (this.inMemoryFormat == InMemoryFormat.NATIVE) {
            return new HDExpirySystemImpl(this, mapContainer, this.mapServiceContext);
        }
        return super.createExpirySystem(mapContainer);
    }

    public RamStore getRamStore() {
        return this.ramStore;
    }

    @Override
    public Storage createStorage(RecordFactory recordFactory, InMemoryFormat memoryFormat) {
        EnterpriseMapServiceContext mapServiceContext = (EnterpriseMapServiceContext)this.mapContainer.getMapServiceContext();
        if (InMemoryFormat.NATIVE == this.inMemoryFormat) {
            EnterpriseSerializationService serializationService = (EnterpriseSerializationService)this.serializationService;
            assert (serializationService != null) : "serializationService is null";
            assert (serializationService.getMemoryManager() != null) : "MemoryManager is null";
            if (this.hotRestartConfig.isEnabled()) {
                return new HotRestartHDStorageImpl(mapServiceContext, recordFactory, this.inMemoryFormat, this.statsEnabled, this.getExpirySystem(), this.hotRestartConfig.isFsync(), this.prefix, this.partitionId);
            }
            HiDensityRecordProcessor<HDRecord> recordProcessor = ((HDRecordFactory)recordFactory).getRecordProcessor();
            return new HDStorageImpl(recordProcessor, this.statsEnabled, this.getExpirySystem(), serializationService);
        }
        if (this.hotRestartConfig.isEnabled()) {
            return new HotRestartStorageImpl(mapServiceContext, recordFactory, memoryFormat, this.statsEnabled, this.getExpirySystem(), this.hotRestartConfig.isFsync(), this.prefix, this.partitionId);
        }
        return super.createStorage(recordFactory, memoryFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        try {
            super.destroy();
        }
        catch (Throwable throwable) {
            Storage storage = this.getStorage();
            if (storage instanceof HotRestartStorage) {
                HotRestartStorage hotRestartStorage = (HotRestartStorage)storage;
                boolean fsync = hotRestartStorage.isFsync();
                hotRestartStorage.getHotRestartStore().clear(fsync, this.prefix);
            }
            throw throwable;
        }
        Storage storage = this.getStorage();
        if (storage instanceof HotRestartStorage) {
            HotRestartStorage hotRestartStorage = (HotRestartStorage)storage;
            boolean fsync = hotRestartStorage.isFsync();
            hotRestartStorage.getHotRestartStore().clear(fsync, this.prefix);
        }
    }

    @Override
    public Record createRecord(Data key, Object value, long now) {
        Record record = super.createRecord(key, value, now);
        if (InMemoryFormat.NATIVE == this.inMemoryFormat) {
            record.setSequence(this.incrementSequence());
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEach(BiConsumer<Data, Record> consumer, boolean backup, boolean includeExpiredRecords, boolean noCaching) {
        assert (this.startIteration()) : "Iteration is not reentrant and already in progress for '" + this.name + "' partitionId=" + this.partitionId;
        try {
            super.forEach(consumer, backup, includeExpiredRecords, noCaching);
        }
        finally {
            assert (this.stopIteration());
        }
    }

    @Override
    public void removeOrEvictEntry(Data dataKey, Record record, boolean eviction, boolean backup) {
        this.assertNoIterationInProgress();
        super.removeOrEvictEntry(dataKey, record, eviction, backup);
    }

    @Override
    public Object evict(Data key, boolean backup) {
        this.assertNoIterationInProgress();
        return super.evict(key, backup);
    }

    @Override
    public void removeRecord0(Data key, @Nonnull Record record, boolean backup) {
        this.assertNoIterationInProgress();
        super.removeRecord0(key, record, backup);
    }

    @Override
    public void reset() {
        super.reset();
        this.disposeDeferredBlocks();
    }

    public long getPrefix() {
        return this.prefix;
    }

    public long incrementSequence() {
        if (this.memoryManager != null && this.ramStore != null) {
            return this.memoryManager.newSequence();
        }
        return -1L;
    }

    private boolean startIteration() {
        if (this.inMemoryFormat != InMemoryFormat.NATIVE) {
            return true;
        }
        try {
            boolean bl = !this.iterationInProgress;
            return bl;
        }
        finally {
            this.iterationInProgress = true;
        }
    }

    private boolean stopIteration() {
        if (this.inMemoryFormat != InMemoryFormat.NATIVE) {
            return true;
        }
        try {
            boolean bl = this.iterationInProgress;
            return bl;
        }
        finally {
            this.iterationInProgress = false;
        }
    }

    private void assertNoIterationInProgress() {
        assert (this.inMemoryFormat != InMemoryFormat.NATIVE || !this.iterationInProgress) : "Removing records from iteration in progress is not allowed";
    }
}

